/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.IN1;

// Common Classes
import gov.va.med.esr.common.builder.entity.InsurancePlanMetaData;
import gov.va.med.esr.common.model.insurance.InsurancePlan;

// Messaging Classes

/**
 * @author Martin Francisco
 */
public class InsurancePlanMetaDataFromIN1
    extends AbstractMetaData
    implements InsurancePlanMetaData
{
    private InsurancePlan entity;

    private IN1 in1;

    public InsurancePlanMetaDataFromIN1(IN1 in1)
    {
        super();

        this.in1 = in1;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.InsurancePlanMetaData#getEntity()
     */
    public InsurancePlan getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.InsurancePlanMetaData#setEntity(gov.va.med.esr.common.model.insurance.InsurancePlan)
     */
    public void setEntity(InsurancePlan entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.InsurancePlanMetaData#getPrecertificationRequired()
     */
    public String getPrecertificationRequired()
    {
        return (this.in1 == null) ? null : this.in1.getPreadmitCertification();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.InsurancePlanMetaData#getType()
     */
    public String getType()
    {
        return (this.in1 == null) ? null : this.in1.getPlanType();
    }
}