/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.MSH;
import gov.va.med.fw.hl7.segment.ZIE;

// Common Classes
import gov.va.med.esr.common.builder.entity.IneligibilityFactorMetaData;
import gov.va.med.esr.common.model.ee.IneligibilityFactor;

// Messaging Class

/**
 * @author Martin Francisco
 */
public class IneligibilityFactorMetaDataFromZIE
    extends AbstractMetaData
    implements IneligibilityFactorMetaData
{
    private IneligibilityFactor entity;

    private ZIE zie;
    private MSH msh;

    public IneligibilityFactorMetaDataFromZIE(ZIE zie, MSH msh)
    {
        super();

        this.zie = zie;
        this.msh = msh;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IneligibilityFactorMetaData#getEntity()
     */
    public IneligibilityFactor getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IneligibilityFactorMetaData#setEntity(gov.va.med.esr.common.model.ee.IneligibilityFactor)
     */
    public void setEntity(IneligibilityFactor entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IneligibilityFactorMetaData#getFacilityReceived()
     */
    public String getFacilityReceived()
    {
        return (this.msh == null) ? null : this.msh.getSendingFacility();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IneligibilityFactorMetaData#getIneligibleDate()
     */
    public String getIneligibleDate()
    {
        return (this.zie == null) ? null : this.zie.getIneligibleDate();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IneligibilityFactorMetaData#getReason()
     */
    public String getReason()
    {
        return (this.zie == null) ? null : this.zie.getIneligibleReason();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IneligibilityFactorMetaData#getVARODecision()
     */
    public String getVARODecision()
    {
        return (this.zie == null) ? null : this.zie.getIneligibleVaroDecision();
    }
}