/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.ZPD;

// Common Classes
import gov.va.med.esr.common.builder.entity.IncompetenceRulingMetaData;
import gov.va.med.esr.common.model.ee.IncompetenceRuling;

// Messaging Class

/**
 * @author Martin Francisco
 */
public class IncompetenceRulingMetaDataFromZPD
    extends AbstractMetaData
    implements IncompetenceRulingMetaData
{
    private IncompetenceRuling entity;

    private ZPD zpd;

    public IncompetenceRulingMetaDataFromZPD(ZPD zpd)
    {
        super();

        this.zpd = zpd;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncompetenceRulingMetaData#getEntity()
     */
    public IncompetenceRuling getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncompetenceRulingMetaData#setEntity(gov.va.med.esr.common.model.ee.IncompetenceRuling)
     */
    public void setEntity(IncompetenceRuling entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncompetenceRulingMetaData#getCivilRulingDate()
     */
    public String getCivilRulingDate()
    {
        return (this.zpd == null) ? null : this.zpd
            .getCivilIncompetentRuledDate();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncompetenceRulingMetaData#getVARulingData()
     */
    public String getVARulingDate()
    {
        return (this.zpd == null) ? null : this.zpd.getVaIncompetentRuledDate();
    }
    
    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.PersonMetaData#getIncompetent()
     */
    public String getIncompetent()
    {
        return (this.zpd == null) ? null : this.zpd.getRatedIncompetent();
    }
    
}