/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes
import java.util.List;

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.ZGD;
import gov.va.med.fw.hl7.segment.ZPD;

// Common Classes
import gov.va.med.esr.common.builder.entity.IncompetenceRulingMetaData;
import gov.va.med.esr.common.model.ee.IncompetenceRuling;

// Messaging Class

/**
 * @author Martin Francisco
 */
public class IncompetenceRulingMetaDataFromZGD
    extends AbstractMetaData
    implements IncompetenceRulingMetaData
{
    private IncompetenceRuling entity;

    private ZGD civilZGD;
    private ZGD vaZGD;

    public IncompetenceRulingMetaDataFromZGD(List zgds, ZPD zpd)
    {
        super();

        this.civilZGD = null;
        this.vaZGD = null;
        
        for(int index = 0; index < ((zgds == null) ? 0 : zgds.size()); index++)
        {
            ZGD current = (ZGD)zgds.get(index);
            if("1".equals(current.getGuardianType()))
            {
                this.vaZGD = current;
            }
            else if("2".equals(current.getGuardianType()))
            {
                this.civilZGD = current;
            }
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncompetenceRulingMetaData#getEntity()
     */
    public IncompetenceRuling getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncompetenceRulingMetaData#setEntity(gov.va.med.esr.common.model.ee.IncompetenceRuling)
     */
    public void setEntity(IncompetenceRuling entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncompetenceRulingMetaData#getCivilRulingDate()
     */
    public String getCivilRulingDate()
    {
        return (this.civilZGD == null) ? null : this.civilZGD
            .getIncompetentRuledDate();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncompetenceRulingMetaData#getVARulingData()
     */
    public String getVARulingDate()
    {
        return (this.vaZGD == null) ? null : this.vaZGD
            .getIncompetentRuledDate();
    }
    
    private String getIncompetentRuledDate()
    {
        ZGD zgd = vaZGD != null? vaZGD:civilZGD;
        
        return zgd.getIncompetentRuledDate();
    }
    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.PersonMetaData#getIncompetent()
     */
    public String getIncompetent()
    {
        //If the rated incompetent is entered (on the Vista side) thru the 
        //registration option then both the ZPD-8 will have a value and if
        //the value is Yes (1), the ZGD will have a date. If rated incompetent
        //is answered No via registration we'll get a 0 in the ZPD-8 but 
        //there won't be any dates in the ZGD.
        //If the incompetent date is entered via the option that lets the 
        //Vista side also enter Guardian info (name etc) then the ZPD-8 will be null 
        //- UNLESS and only unless the site also answers Yes via the Registration option.
 
        //If ZPD-8 is Yes - vet is incompetent and ZGD will have dates
        //If ZPD-8 is No - then check ZGD - if there are dates assume the vet is incompetent.
        
        //So if dates are present in ZGD, then it is always incompetent
        return (getIncompetentRuledDate() != null) ?"1":"0" ;
    }
    
}