/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.ZMT;

// Common Classes
import gov.va.med.esr.common.builder.entity.IncomeTestStatusMetaData;
import gov.va.med.esr.common.model.financials.IncomeTestStatus;

// Messaging Classes

public class IncomeTestStatusMetaDataFromZMT
    extends AbstractMetaData
    implements IncomeTestStatusMetaData
{
    private IncomeTestStatus entity;

    private ZMT zmt;

    public IncomeTestStatusMetaDataFromZMT(ZMT zmt)
    {
        super();

        this.zmt = zmt;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestStatusMetaData#getEntity()
     */
    public IncomeTestStatus getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestStatusMetaData#setEntity(gov.va.med.esr.common.model.financials.IncomeTestStatus)
     */
    public void setEntity(IncomeTestStatus entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestStatusMetaData#getCompletedDate()
     */
    public String getCompletedDate()
    {
        return (this.zmt == null) ? null : this.zmt.getMeansTestCompletedDate();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestStatusMetaData#getDeterminedStatus()
     */
    public String getDeterminedStatus()
    {
        return (this.zmt == null) ? null : this.zmt.getTestDeterminedStatus();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestStatusMetaData#getLastEditedDate()
     */
    public String getLastEditedDate()
    {
        return (this.zmt == null) ? null : this.zmt.getTestLastEditedDate();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestStatusMetaData#getStatus()
     */
    public String getStatus()
    {
        return (this.zmt == null) ? null : this.zmt.getMeansTestStatus();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestStatusMetaData#getType()
     */
    public String getType()
    {
        return (this.zmt == null) ? null : this.zmt.getTestType();
    }
}