/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import java.text.SimpleDateFormat;
import java.util.Date;

import gov.va.med.fw.hl7.segment.ZMT;

// Common Classes
import gov.va.med.esr.common.builder.entity.IncomeTestStatusMetaData;
import gov.va.med.esr.common.model.financials.IncomeTestStatus;
import gov.va.med.esr.service.external.person.IncomeTestStatusInfo;

// Messaging Classes

public class IncomeTestStatusMetaDataFromIVM
    extends AbstractMetaData
    implements IncomeTestStatusMetaData
{
    private IncomeTestStatus entity;

    private IncomeTestStatusInfo status ;
    
    private String impreciseDateFormat ="yyyyMMdd";

    public IncomeTestStatusMetaDataFromIVM(IncomeTestStatusInfo status)
    {
        super();

        this.status = status;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestStatusMetaData#getEntity()
     */
    public IncomeTestStatus getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestStatusMetaData#setEntity(gov.va.med.esr.common.model.financials.IncomeTestStatus)
     */
    public void setEntity(IncomeTestStatus entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestStatusMetaData#getCompletedDate()
     */
    public String getCompletedDate()
    {
        return (this.status == null) ? null : toImpreciseDateFormat(this.status.getCompletedDate());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestStatusMetaData#getDeterminedStatus()
     */
    public String getDeterminedStatus()
    {
        return (this.status == null) ? null : processIncomingCode(this.status.getDeterminedStatus());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestStatusMetaData#getLastEditedDate()
     */
    public String getLastEditedDate()
    {
        return (this.status == null) ? null : toImpreciseDateFormat(this.status.getLastEditedDate());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestStatusMetaData#getStatus()
     */
    public String getStatus()
    {
        return (this.status == null) ? null : processIncomingCode(this.status.getStatus());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestStatusMetaData#getType()
     */
    public String getType()
    {
        return (this.status == null) ? null : processIncomingCode(this.status.getIncomeTestType());
    }
    
    private String toImpreciseDateFormat(Date date) {
        if (date != null) {
            SimpleDateFormat format = new SimpleDateFormat(impreciseDateFormat);
            return format.format(date);        
        }
        return "";
    }
    
    private String processIncomingCode(String incomingCode) {

    	if (incomingCode != null) {
    		int separatorLoc = incomingCode.indexOf("^");
    		if(separatorLoc < 0){
    			return (incomingCode.startsWith("0"))? incomingCode.substring(1):incomingCode;

    		}
    		else{
    			return (incomingCode.startsWith("0"))? incomingCode.substring(1,separatorLoc):incomingCode.substring(0,separatorLoc);        		
    		}   
    	}
    	return incomingCode;
    }
}