/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes
import java.util.ArrayList;
import java.util.List;

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.NTE;
import gov.va.med.fw.hl7.segment.ZIC;
import gov.va.med.fw.hl7.segment.ZMT;
import gov.va.med.fw.hl7.segment.ZPD;
import gov.va.med.fw.util.StringUtils;

// Common Classes
import gov.va.med.esr.common.builder.datatype.metadata.FT;
import gov.va.med.esr.common.builder.entity.AddressMetaData;
import gov.va.med.esr.common.builder.entity.HardshipMetaData;
import gov.va.med.esr.common.builder.entity.IncomeTestMetaData;
import gov.va.med.esr.common.builder.entity.IncomeTestStatusMetaData;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.util.CommonDateUtils;

// Messaging Classes

public class IncomeTestMetaDataFromZMT
    extends AbstractMetaData
    implements IncomeTestMetaData
{
    private IncomeTest entity;

    private ZIC zic;
    private ZMT zmt;
    private ZPD zpd;

    private HardshipMetaData hardship;
    private IncomeTestStatusMetaData[] statuses;
    private String comments;
    private String site;
    private boolean containsDeleteRequest=false;
    
    public IncomeTestMetaDataFromZMT(ZPD zpd, List zmts, List ntes, ZIC zic, String site)
    {
        super();

        this.processZMTs(zmts);

        this.zic = zic;

        this.hardship = (zmt == null) ? null : new HardshipMetaDataFromZMT(zmt);
        
        this.site = site;
        this.comments = this.processComments(ntes);
        
        this.zpd = zpd;
        
    }
    

    private String processComments(List ntes)
    {
        String result = null;

        for(int nteIndex = 0; nteIndex < ((ntes == null) ? 0 : ntes.size()); nteIndex++)
        {
            NTE nte = (NTE)ntes.get(nteIndex);

            FT[] fts = FT.create(nte.getComment(), nte.getRepeatDelimiter());

            for(int ftIndex = 0; ftIndex < ((fts == null) ? 0 : fts.length); ftIndex++)
            {
                String comment = fts[ftIndex].getDataString();

                if((comment != null) && (comment.length() > 0)
                    && !("\"\"".equals(comment)))
                {
                    result = ((result == null) ? "" : result + "\n") + comment;
                }
            }
        }

        return result;
    }

    private boolean isDeleteRequest(ZMT zmt){
    	return (zmt.getMeansTestDate() != null 
                && !zmt.getMeansTestDate().equals(StringUtils.EMPTY) 
                && zmt.getMeansTestStatus().equals(StringUtils.EMPTY));
    }
    
    
    /**
     * 
     * @param zmts
     */
    private void processZMTs(List zmts)
    {
        List filledZMTs = new ArrayList();
        
        for(int index = 0; index < ((zmts == null) ? 0 : zmts.size()); index++)
        {
        	ZMT zmt = (ZMT)zmts.get(index);
        	
        	//if the segment has  means test date , means test status is an empty string, 
        	//and all other fields in the segment are null
        	if(	isDeleteRequest(zmt)){
        		        	
        		//then this segment contains a request to delete an income test.
        		//clear existing ZMT segments from the filled ZMT list
        		this.zmt=null;
        		filledZMTs.clear();
        		containsDeleteRequest=true;
        		
        		//break from the loop
        		break;
        	}
        	
            if((zmt.getMeansTestDate() != null)
                && !zmt.getMeansTestDate().equals(StringUtils.EMPTY))
            { 
                //Usually the ZMT segments will be for IncomeTestTypes 1,2,4 OR 1,2 OR 1,4 OR 2,4
                //The first ZMT segment will contain the IncomeTest data (and will be the PrimaryIncomeTest)
                //and the rest of the segments may contain only the status or they 
                //could contain more IncomeTestData but will be repeating as the first segment.
                //So set the first segment as the ZMT segment from which the common IncomeTest data will be 
                //populated.
                if(this.zmt == null)
                 {
                    this.zmt = zmt;
                }
                
                filledZMTs.add(new IncomeTestStatusMetaDataFromZMT(zmt));
            }
        }
        
        this.statuses = new IncomeTestStatusMetaData[filledZMTs.size()];

        if(filledZMTs.size() > 0)
        {
            this.statuses = (IncomeTestStatusMetaData[])filledZMTs
                .toArray(this.statuses);
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getEntity()
     */
    public IncomeTest getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#setEntity(gov.va.med.esr.common.model.financials.IncomeTest)
     */
    public void setEntity(IncomeTest entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getAdjudicationDate()
     */
    public String getAdjudicationDate()
    {
        return (this.zmt == null) ? null : this.zmt.getAdjudicationDate();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getAgreesToPayDeductible()
     */
    public String getAgreesToPayDeductible()
    {
        return (this.zmt == null) ? null : this.zmt.getAgreedToPayDeductible();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getComments()
     */
    public String getComments()
    {
        return this.comments;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getDateMTNoLongerRequired()
     */
    public String getDateMTNoLongerRequired()
    {
        return null;
    }

    /**
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getDeductibleExpenses()
     */
    public String getDeductibleExpenses()
    {
        return (this.zmt == null) ? null : this.zmt.getDeductibleExpenses();
    }

    /**
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getDiscloseFinancialInformation()
     */
    public String getDiscloseFinancialInformation()
    {
        if(this.zmt == null)
        {
            return null;
        }
        else if("0".equals(this.zmt.getDeclinesToGiveIncomeInfo())
            || "N".equals(this.zmt.getDeclinesToGiveIncomeInfo()))
        {
            return "1";
        }
        else if("1".equals(this.zmt.getDeclinesToGiveIncomeInfo())
            || "Y".equals(this.zmt.getDeclinesToGiveIncomeInfo()))
        {
            return "0";
        }
        else
        {
            // default means no answer, as per req 4060
            return "1";
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getEffectiveDate()
     */
    public String getEffectiveDate()
    {
        return (this.zmt == null) ? null : this.zmt.getMeansTestDate();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getGMTAddress()
     */
    public AddressMetaData getGMTAddress()
    {
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getGMTThresholdAmount()
     */
    public String getGMTThresholdAmount()
    {
        return (this.zmt == null) ? null : this.zmt.getGmtThreshold();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getHardship()
     */
    public HardshipMetaData getHardship()
    {
        return this.hardship;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getIncomeVerificationStatus()
     */
    public String getIncomeVerificationStatus()
    {
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getIncomeVerificationStatusDate()
     */
    public String getIncomeVerificationStatusDate()
    {
        return (this.zmt == null) ? null : this.zmt
            .getIvmVerifiedMTCompletedDate();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getIncomeYear()
     */
    public String getIncomeYear()
    {
        return (this.zic == null) ? null : this.zic.getIncomeYear();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getIVMTestCompletionDate()
     */
    public String getIVMTestCompletionDate()
    {
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getNetWorth()
     */
    public String getNetWorth()
    {
        return (this.zmt == null) ? null : this.zmt.getNetWorth();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getPreviousYearThresholdApplies()
     */
    public String getPreviousYearThresholdApplies()
    {
        return (this.zmt == null) ? null : this.zmt
            .getPreviousYearMTThresholdFlag();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getPrimaryIncomeTest()
     */
    public String getPrimaryIncomeTest()
    {
        return (this.zmt == null) ? null : this.zmt.getPrimaryTest();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getReasonMTNoLongerRequired()
     */
    public String getReasonMTNoLongerRequired()
    {
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getRefusedToSign()
     */
    public String getRefusedToSign()
    {
        return (this.zmt == null) ? null : this.zmt.getRefusedToSign();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getSignatureDate()
     */
    public String getSignatureDate()
    {
        return (this.zmt == null) ? null : this.zmt.getVeteranTestSignedDate();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getSiteConductingTest()
     */
    public String getSiteConductingTest()
    {
        return (this.zmt == null) ? null : this.zmt.getTestConductingSite();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getSource()
     */
    public String getSource()
    {
        return (this.zmt == null) ? null : this.zmt.getTestSource();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getStatuses()
     */
    public IncomeTestStatusMetaData[] getStatuses()
    {
        return this.statuses;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getThresholdA()
     */
    public String getThresholdA()
    {
        return (this.zmt == null) ? null : this.zmt.getThresholdA();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getTotalIncome()
     */
    public String getTotalIncome()
    {
        return (this.zmt == null) ? null : this.zmt.getIncome();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getTotalNumberOfDependents()
     */
    public String getTotalNumberOfDependents()
    {
        return (this.zmt == null) ? null : this.zmt.getTotalDependents();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getType()
     */
    public String getType()
    {
        return (this.zmt == null) ? null : this.zmt.getTestType();
    }

	/* (non-Javadoc)
	 * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getSite()
	 */
	public String getSite() {
		return site;
	}
    
    /*
     *  (non-Javadoc)
     * @see gov.va.med.esr.common.builder.entity.IncomeTestMetaData#getRxCopayExemptionStatus()
     */
    public String getRxCopayExemptionStatus() {
        return (this.zpd == null) ? null : this.zpd.getMedicationCopayExemptionStatus();
    }

	public boolean isContainsDeleteRequest() {
		return containsDeleteRequest;
	}
	
	public String getIVMConversionDate()
    {
    	return null;
    }
    
    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getPg8RelaxationIndicator()
     */
    public String getPg8RelaxationIndicator()
    {
        return null;
    }
    
    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getIncomeVerificationStatus()
     */
    public String getIvmCaseStatus()
    {
    	return null;
    }
    
	public String getBtFinancialInd() {
		// This indicator is ignored when received from Vista so don't bother to build it.
		return null;
	}    
}