/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.NTE;
import gov.va.med.fw.hl7.segment.ZIC;
import gov.va.med.fw.hl7.segment.ZMT;
import gov.va.med.fw.hl7.segment.ZPD;
import gov.va.med.fw.util.StringUtils;

// Common Classes
import gov.va.med.esr.common.builder.datatype.metadata.FT;
import gov.va.med.esr.common.builder.entity.AddressMetaData;
import gov.va.med.esr.common.builder.entity.HardshipMetaData;
import gov.va.med.esr.common.builder.entity.IncomeTestMetaData;
import gov.va.med.esr.common.builder.entity.IncomeTestStatusMetaData;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.util.CommonDateUtils;
import gov.va.med.esr.service.external.person.IncomeTestInfo;
import gov.va.med.esr.service.external.person.IncomeTestStatusInfo;

// Messaging Classes

public class IncomeTestMetaDataFromIVM
    extends AbstractMetaData
    implements IncomeTestMetaData
{
    private IncomeTest entity;    
    private IncomeTestInfo ivmIncomeTestInfo;
    //private HardshipMetaData hardship;
    private IncomeTestStatusMetaData[] statuses;    
    private String site;
    private boolean containsDeleteRequest=false;
    private String impreciseDateFormat ="yyyyMMdd";
    private String incomeYear;
    
    public IncomeTestMetaDataFromIVM(IncomeTestInfo ivmIncomeTestInfo, String actionCode, Integer incomeYear)
    {
        super();

        this.processIncomeTestInfo(ivmIncomeTestInfo, actionCode);         
        this.site = null;
        this.incomeYear = incomeYear == null ? null : incomeYear.toString();        
        
    } 
    

    private boolean isDeleteRequest(String actionCode){
    	return (actionCode.equals("R"));
    }
    
    
    /**
     * 
     * @param zmts
     */
    private void processIncomeTestInfo(IncomeTestInfo ivmIncomeTestInfo, String actionCode)
    {
        List filledStatus = new ArrayList();
        if(	isDeleteRequest(actionCode)){           	
    		//then this segment contains a request to delete an income test.
    		//clear existing ZMT segments from the filled ZMT list
        	ivmIncomeTestInfo = null;
    		containsDeleteRequest=true;        		
    	}
        else{        	
        	this.ivmIncomeTestInfo = ivmIncomeTestInfo;
        	if(ivmIncomeTestInfo != null && ivmIncomeTestInfo.getStatuses() != null){
        		for(int index = 0; index < ((ivmIncomeTestInfo.getStatuses().getStatus() == null) ? 0 : ivmIncomeTestInfo.getStatuses().getStatus().length); index++){
        			IncomeTestStatusInfo status = ivmIncomeTestInfo.getStatuses().getStatus()[index];
        			filledStatus.add(new IncomeTestStatusMetaDataFromIVM(status));
            	}        		
        	}
        	this.statuses = new IncomeTestStatusMetaData[filledStatus.size()];

            if(filledStatus.size() > 0)
            {
                this.statuses = (IncomeTestStatusMetaData[])filledStatus
                    .toArray(this.statuses);
            }
        }        
        
        this.statuses = new IncomeTestStatusMetaData[filledStatus.size()];

        if(filledStatus.size() > 0)
        {
            this.statuses = (IncomeTestStatusMetaData[])filledStatus
                .toArray(this.statuses);
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getEntity()
     */
    public IncomeTest getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#setEntity(gov.va.med.esr.common.model.financials.IncomeTest)
     */
    public void setEntity(IncomeTest entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getAdjudicationDate()
     */
    public String getAdjudicationDate()
    {
        return null;
        //(this.ivmIncomeTestInfo == null) ? null : toImpreciseDateFormat(this.ivmIncomeTestInfo.getAdjudicationDate());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getAgreesToPayDeductible()
     */
    public String getAgreesToPayDeductible()
    {
        return (this.ivmIncomeTestInfo == null) ? null : this.ivmIncomeTestInfo.getAgreesToPayDeductible()== null ? null :this.ivmIncomeTestInfo.getAgreesToPayDeductible()? "Y" : "N";
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getComments()
     */
    public String getComments()
    {
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getDateMTNoLongerRequired()
     */
    public String getDateMTNoLongerRequired()
    {
        return null;
    }

    /**
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getDeductibleExpenses()
     */
    public String getDeductibleExpenses()
    {
        return null;
    }

    /**
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getDiscloseFinancialInformation()
     */
    public String getDiscloseFinancialInformation()
    {
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getEffectiveDate()
     */
    public String getEffectiveDate()
    {
        return (this.ivmIncomeTestInfo == null) ? null : toImpreciseDateFormat(this.ivmIncomeTestInfo.getEffectiveDate());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getGMTAddress()
     */
    public AddressMetaData getGMTAddress()
    {
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getGMTThresholdAmount()
     */
    public String getGMTThresholdAmount()
    {
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getHardship()
     */
    public HardshipMetaData getHardship()
    {
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getIncomeVerificationStatus()
     */
    public String getIncomeVerificationStatus()
    {
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getIncomeVerificationStatusDate()
     */
    public String getIncomeVerificationStatusDate()
    {
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getIncomeYear()
     */
    public String getIncomeYear()
    {
        return this.incomeYear;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getIVMTestCompletionDate()
     */
    public String getIVMTestCompletionDate()
    {
    	return (this.ivmIncomeTestInfo == null) ? null : toImpreciseDateFormat(this.ivmIncomeTestInfo.getIvmTestCompletionDate());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getNetWorth()
     */
    public String getNetWorth()
    {
    	return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getPreviousYearThresholdApplies()
     */
    public String getPreviousYearThresholdApplies()
    {
    	return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getPrimaryIncomeTest()
     */
    public String getPrimaryIncomeTest()
    {
    	return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getReasonMTNoLongerRequired()
     */
    public String getReasonMTNoLongerRequired()
    {
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getRefusedToSign()
     */
    public String getRefusedToSign()
    {
    	return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getSignatureDate()
     */
    public String getSignatureDate()
    {
    	return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getSiteConductingTest()
     */
    public String getSiteConductingTest()
    {
    	return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getSource()
     */
    public String getSource()
    {
    	//preset the source to IVM 
        return (this.ivmIncomeTestInfo == null) ? null : "2";
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getStatuses()
     */
    public IncomeTestStatusMetaData[] getStatuses()
    {
        return this.statuses;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getThresholdA()
     */
    public String getThresholdA()
    {
        return (this.ivmIncomeTestInfo == null) ? null : this.ivmIncomeTestInfo.getThresholdA() == null ? null : this.ivmIncomeTestInfo.getThresholdA().toString();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getTotalIncome()
     */
    public String getTotalIncome()
    {
    	return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getTotalNumberOfDependents()
     */
    public String getTotalNumberOfDependents()
    {
        return (this.ivmIncomeTestInfo == null) ? null : this.ivmIncomeTestInfo.getTotalNumberOfDependents() == null? null : this.ivmIncomeTestInfo.getTotalNumberOfDependents().toString();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getType()
     */
    public String getType()
    {
        return (this.ivmIncomeTestInfo == null) ? null : processIncomingCode(this.ivmIncomeTestInfo.getIncomeTestType());
    }

	/* (non-Javadoc)
	 * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getSite()
	 */
	public String getSite() {
		return null;
	}
    
    /*
     *  (non-Javadoc)
     * @see gov.va.med.esr.common.builder.entity.IncomeTestMetaData#getRxCopayExemptionStatus()
     */
    public String getRxCopayExemptionStatus() {    	
        return null;
    }

	public boolean isContainsDeleteRequest() {
		return containsDeleteRequest;
	}
	
	/*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getIVMConversionDate()
     */
    public String getIVMConversionDate()
    {
    	return (this.ivmIncomeTestInfo == null) ? null : toImpreciseDateFormat(this.ivmIncomeTestInfo.getIvmConversionDate());
    	//return (this.ivmIncomeTestInfo == null) ? null : toImpreciseDateFormat(this.ivmIncomeTestInfo.getIvmTestCompletionDate());
    }
    
    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getPg8RelaxationIndicator()
     */
    public String getPg8RelaxationIndicator()
    {
    	return (this.ivmIncomeTestInfo == null) ? null : this.ivmIncomeTestInfo.getPriorityGroup8Relaxation()== null ? null :this.ivmIncomeTestInfo.getPriorityGroup8Relaxation()? "Y" : "N";
    }
    
    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.IncomeTestMetaData#getIncomeVerificationStatus()
     */
    public String getIvmCaseStatus()
    {
    	return (this.ivmIncomeTestInfo == null) ? null : this.ivmIncomeTestInfo.getIvmCaseStatus() == null ? null : this.ivmIncomeTestInfo.getIvmCaseStatus().toString();
    }
    
	public String getBtFinancialInd() {
		// The BT Financial Indicator is separate from the income test data received from IVM
		// even though eventually it does get persisted in ES' income test.
		// Only Messaging MetaData needs to use this method.
		return null;
	}

	private String toImpreciseDateFormat(Date date) {
        if (date != null) {
            SimpleDateFormat format = new SimpleDateFormat(impreciseDateFormat);
            return format.format(date);        
        }
        return "";
    }
	
	private String processIncomingCode(String incomingCode) {
		
        if (incomingCode != null) {
        	int separatorLoc = incomingCode.indexOf("^");
        	if(separatorLoc < 0){
        		return (incomingCode.startsWith("0"))? incomingCode.substring(1):incomingCode;
        		
        	}
        	else{
        		return (incomingCode.startsWith("0"))? incomingCode.substring(1,separatorLoc):incomingCode.substring(0,separatorLoc);        		
        	}   
        }
        return incomingCode;
    }
}