package gov.va.med.esr.common.builder.entity.metaData;

import gov.va.med.esr.common.builder.entity.HealthBenefitPlanMetaData;
import gov.va.med.esr.common.model.ee.HealthBenefitPlan;
import gov.va.med.fw.hl7.segment.ZHP;


/**
 * Health Benefit Plan metadata from ZHP
 * 
 * @author DNS   zhangs Created on Feb., 2013
 * @version 1.0
 * 
 * Copyright  2013 VHA. All rights reserved
 */
public class HealthBenefitPlanMetaDataFromZHP extends AbstractMetaData implements HealthBenefitPlanMetaData
{
    private HealthBenefitPlan entity;

    private ZHP zhp;

   
    public HealthBenefitPlanMetaDataFromZHP(ZHP zhp)
    {
        super();
        this.zhp = zhp;
            
    }


    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.HealthBenefitPlanMetaData#getEntity()
     */
    public gov.va.med.esr.common.model.ee.HealthBenefitPlan getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.HealthBenefitPlanMetaData#setEntity(gov.va.med.esr.common.model.ee.HealthBenefitPlan)
     */
    public void setEntity(HealthBenefitPlan entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.common.builder.entity.HealthBenefitPlanMetaData#getHBPCode()
     */
    public String getHBPCode()
    {
       return (this.zhp == null) ? null : this.zhp.getHBPCode();
     
    }

  

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.common.builder.entity.HealthBenefitPlanMetaData#getHBPLastUpdatedBySource()
     */
    public String getHBPLastUpdatedBySource()
    {
        return (this.zhp == null) ? null : this.zhp.getHBPLastUpdatedBySource();
     
    }
    

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.common.builder.entity.getHBPLastUpdatedBySource#getHBPLastUpdatedBySite()
     */
    public String getHBPLastUpdatedBySite()
    {
        return (this.zhp == null) ? null : this.zhp.getHBPLastUpdatedBySite();
    }

       /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.common.builder.entity.getHBPLastUpdatedBySite#getHBPLastUpdatedDate()
     */
    public String getHBPLastUpdatedDate()
    {
        return (this.zhp == null) ? null : this.zhp.getHBPLastUpdatedDate();
               
    }

}