/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.ZMT;

// Common Classes
import gov.va.med.esr.common.builder.entity.HardshipMetaData;
import gov.va.med.esr.common.model.financials.Hardship;

// Messaging Classes

public class HardshipMetaDataFromZMT
    extends AbstractMetaData
    implements HardshipMetaData
{
    private Hardship entity;

    private ZMT zmt;

    public HardshipMetaDataFromZMT(ZMT zmt)
    {
        super();

        this.zmt = zmt;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.HardshipMetaData#getEntity()
     */
    public Hardship getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.HardshipMetaData#setEntity(gov.va.med.esr.common.model.financials.Hardship)
     */
    public void setEntity(Hardship entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.HardshipMetaData#getEffectiveDate()
     */
    public String getEffectiveDate()
    {
        return (this.zmt == null) ? null : this.zmt.getHardshipEffectiveDate();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.HardshipMetaData#getHardshipGranted()
     */
    public String getHardshipGranted()
    {
        return (this.zmt == null) ? null : this.zmt.getHardship();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.HardshipMetaData#getReason()
     */
    public String getReason()
    {
        return (this.zmt == null) ? null : this.zmt.getHardshipReason();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.HardshipMetaData#getReviewDate()
     */
    public String getReviewDate()
    {
        return (this.zmt == null) ? null : this.zmt.getHardshipReviewDate();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.HardshipMetaData#getSiteGrantingHardship()
     */
    public String getSiteGrantingHardship()
    {
        return (this.zmt == null) ? null : this.zmt.getHardshipReviewSite();
    }
}