/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.Segment;
import gov.va.med.fw.hl7.segment.ZDP;
import gov.va.med.fw.hl7.segment.ZEM;
import gov.va.med.fw.hl7.segment.ZIC;
import gov.va.med.fw.hl7.segment.ZIR;
import gov.va.med.fw.hl7.segment.ZMT;

// Common Classes
import gov.va.med.esr.common.builder.entity.FinancialInformationMetaData;
import gov.va.med.esr.common.builder.entity.FinancialStatementMetaData;
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.lookup.Relationship;

// Messaging Classes

public class FinancialStatementMetaDataFromZIC
    extends FinancialInformationMetaDataFromZIC
    implements FinancialStatementMetaData
{
    private FinancialStatement entity;

    private ZIR zir = null;
    private ZMT zmt = null;

    private FinancialInformationMetaData[] supportingInformation;

    public FinancialStatementMetaDataFromZIC(ZIC zic, ZMT zmt, List segments)
    {
        super(zic, zmt);

        this.zmt =zmt;       

        this.processSegments(segments);
    }

    /**
     * Add Financial info for Spouse and Dependendents
     * 
     * @param segments
     */
    private void processSegments(List segments)
    {
        //Employment Info Segment for spouse
        ZEM zem = null;

        boolean onDependents = false;
        //Set of all Dependents. Contains dependentSegments.
        Set dependents = new HashSet();
        
        //dependentSegments[0] = ZDP, dependentSegments[1] = ZIC, dependentSegments[2]= ZIR
        Segment[] dependentSegments = null;

        for(Iterator i = segments.iterator(); i.hasNext();)
        { 
            //{ZDP, ZIC, ZIR} are in one sequence. Could be multiple combinations of these.
            
            Segment current = (Segment)i.next();
            //ZEM - Employment Info Segment
            if(current instanceof ZEM)
            {
                ZEM temp = (ZEM)current;
                //1 = Patient, 2= Spouse
                if("2".equals(temp.getSetID()))
                {
                    zem = temp;
                }
            }//ZIC Specific Income Segment - existing format/new 1010 EZ format
            else if(current instanceof ZIC)
            {
                if(onDependents && dependentSegments != null)
                {
                    dependentSegments[1] = current;
                }
            }//ZIR - Specific Income Relation segment
            else if(current instanceof ZIR)
            {
                if(onDependents && dependentSegments != null)
                {
                    dependentSegments[2] = current;
                }
                else
                {
                    this.zir = (ZIR)current;
                }
            }//ZDP - Specific Dependent Info Segment
            else if(current instanceof ZDP)
            {
                onDependents = true;
                dependentSegments = new Segment[3];
                dependentSegments[0] = current;
                dependents.add(dependentSegments);
            }
        }

        this.supportingInformation = new FinancialInformationMetaData[dependents
            .size()];
        int index = 0;
        for(Iterator i = dependents.iterator(); i.hasNext(); index++)
        {
            Segment[] current = (Segment[])i.next();
            ZDP zdp = (ZDP)current[0];
            ZIC zic = (ZIC)current[1];
            ZIR zir = (ZIR)current[2];

            if(Relationship.CODE_SPOUSE.getName().equals(zdp.getRelationship()))
            {
                this.supportingInformation[index] = new SpouseFinancialsMetaDataFromZDP(
                    zdp, zic, zir, zem, this.zir, this.zmt);
            }
            else
            {
                this.supportingInformation[index] = new DependentFinancialsMetaDataFromZDP(
                    zdp, zic, zir, this.zmt);
            }
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.FinancialStatementMetaData#getEntity()
     */
    public FinancialStatement getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.FinancialStatementMetaData#setEntity(gov.va.med.esr.common.model.financials.FinancialStatement)
     */
    public void setEntity(FinancialStatement entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.FinancialStatementMetaData#getContributionToSpouse()
     */
    public String getContributionToSpouse()
    {
        return (this.zir == null) ? null : this.zir
            .getAmountContributedToSpouseDep();
    }
    
    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.FinancialStatementMetaData#getContributionToSpouse()
     */
    public String getContributedToSpouseInd()
    {
        return (this.zir == null) ? null : this.zir.getSpousalSupportIndicator();
            
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.FinancialStatementMetaData#getMarriedLastCalendarYear()
     */
    public String getMarriedLastCalendarYear()
    {
        return (this.zir == null) ? null : this.zir
            .getMarriedLastCalendarYear();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.FinancialStatementMetaData#getNumberOfDependentChildren()
     */
    public String getNumberOfDependentChildren()
    {
        return (this.zir == null) ? null : this.zir
            .getNumberOfDependentChildren();
    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.messaging.builder.entity.FinancialStatementMetaData#getIncomeSegmentFormat()
     */
    public String getMeansTestVersion()
    {
        return (this.zmt == null) ? null : this.zmt.getMeansTestVersion();
    }
    
    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.FinancialStatementMetaData#getSupportingInformation()
     */
    public FinancialInformationMetaData[] getSupportingInformation()
    {
        return this.supportingInformation;
    }

 
}