/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

// Library Classes

// Framework Classes

// Common Classes
import gov.va.med.esr.common.builder.entity.FinancialInformationMetaData;
import gov.va.med.esr.common.builder.entity.FinancialStatementMetaData;
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.service.external.person.DependentFinancialsInfo;
import gov.va.med.esr.service.external.person.FinancialStatementInfo;
import gov.va.med.esr.service.external.person.SpouseFinancialsInfo;
import gov.va.med.esr.service.external.person.collections.DependentFinancialsCollection;
import gov.va.med.esr.service.external.person.collections.SpouseFinancialsCollection;

// Messaging Classes

public class FinancialStatementMetaDataFromIVM
    extends FinancialInformationMetaDataFromIVM
    implements FinancialStatementMetaData
{
    private FinancialStatement entity;
    
    private FinancialStatementInfo financialStatementInfo;    

    private FinancialInformationMetaData[] supportingInformation;

    public FinancialStatementMetaDataFromIVM(FinancialStatementInfo financialStatementInfo, String incomeYear)
    {
        super(financialStatementInfo, incomeYear);

        this.financialStatementInfo = financialStatementInfo;       

        this.processSegments(financialStatementInfo.getSpouseFinancialsList(), financialStatementInfo.getDependentFinancialsList(),incomeYear);
    }
    
    /**
     * Add Financial info for Spouse and Dependendents
     * 
     * @param segments
     */
    private void processSegments(SpouseFinancialsCollection spouseFinancialsList, DependentFinancialsCollection dependentFinancialsList, String incomeYear)
    {
        List spouseSegments = Arrays.asList(spouseFinancialsList.getSpouseFinancials());
        List dependentSegments = Arrays.asList(dependentFinancialsList.getDependentFinancials());        
        
        this.supportingInformation = new FinancialInformationMetaData[spouseSegments.size() + dependentSegments.size()];
        int index = 0;
        for(Iterator i = spouseSegments.iterator(); i.hasNext(); index++)
        {  
        	this.supportingInformation[index] = new SpouseFinancialsMetaDataFromIVM((SpouseFinancialsInfo)i.next(), incomeYear);              
        }
        
        index = supportingInformation.length - 0;
        
        for(Iterator i = dependentSegments.iterator(); i.hasNext(); index++)
        {
        	this.supportingInformation[index] = new DependentFinancialsMetaDataFromIVM((DependentFinancialsInfo)i.next(), incomeYear);            
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.FinancialStatementMetaData#getEntity()
     */
    public FinancialStatement getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.FinancialStatementMetaData#setEntity(gov.va.med.esr.common.model.financials.FinancialStatement)
     */
    public void setEntity(FinancialStatement entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.FinancialStatementMetaData#getContributionToSpouse()
     */
    public String getContributionToSpouse()
    {
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.FinancialStatementMetaData#getMarriedLastCalendarYear()
     */
    public String getMarriedLastCalendarYear()
    {
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.FinancialStatementMetaData#getNumberOfDependentChildren()
     */
    public String getNumberOfDependentChildren()
    {
        return null;
    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.messaging.builder.entity.FinancialStatementMetaData#getIncomeSegmentFormat()
     */
    public String getMeansTestVersion()
    {
        return null;
    }
    
    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.FinancialStatementMetaData#getSupportingInformation()
     */
    public FinancialInformationMetaData[] getSupportingInformation()
    {
        return this.supportingInformation;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.FinancialStatementMetaData#getContributedToSpouse()
     */
	public String getContributedToSpouseInd() {
		
		return null;
	}

 
}