/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.ZIC;
import gov.va.med.fw.hl7.segment.ZMT;

import gov.va.med.esr.common.builder.entity.AssetMetaData;
import gov.va.med.esr.common.builder.entity.DebtMetaData;
import gov.va.med.esr.common.builder.entity.ExpenseMetaData;
import gov.va.med.esr.common.builder.entity.FinancialInformationMetaData;
import gov.va.med.esr.common.builder.entity.IncomeMetaData;
import gov.va.med.esr.common.model.lookup.AssetType;
import gov.va.med.esr.common.model.lookup.ExpenseType;
import gov.va.med.esr.common.model.lookup.IncomeType;
import gov.va.med.esr.common.util.CommonDateUtils;

public abstract class FinancialInformationMetaDataFromZIC
    extends AbstractMetaData
    implements FinancialInformationMetaData
{
    private ZIC zic;

    private AssetMetaData[] assets;
    private DebtMetaData debt;
    private ExpenseMetaData[] expenses;
    private IncomeMetaData[] income;

    public FinancialInformationMetaDataFromZIC(ZIC zic, ZMT zmt)
    {
        super();

        this.zic = zic;
        
        this.assets = (zic == null) ? null : this.buildAssets(zic);
        this.debt = (zic == null) ? null : new DebtMetaDataFromZIC(zic);
        this.expenses = (zic == null) ? null : this.buildExpenses(zic);
        this.income = (zic == null) ? null : this.buildIncome(zic, zmt);
        
    }
    


    private AssetMetaData[] buildAssets(ZIC zic)
    {
        AssetMetaData[] results = new AssetMetaData[4];
 
        results[0] = new AssetMetaDataFromZICPosition(zic
                .getCashAmountInBankAccounts(),  AssetType.CODE_CASH.getName());
        results[1] = new AssetMetaDataFromZICPosition(zic.getStocksAndBonds(),
                AssetType.CODE_STOCKS_AND_BONDS.getName());
        results[2] = new AssetMetaDataFromZICPosition(zic.getRealProperty(),
                AssetType.CODE_REAL_ESTATE.getName());
        results[3] = new AssetMetaDataFromZICPosition(zic
                .getOtherPropertyAssets(), AssetType.CODE_OTHER.getName());
 
        return results;
    }

    protected ExpenseMetaData[] buildExpenses(ZIC zic)
    {
        ExpenseMetaData[] results = new ExpenseMetaData[3];
        results[0] = new ExpenseMetaDataFromZICPosition(zic
            .getMedicalExpenses(), ExpenseType.EXPENSE_TYPE_ADJUSTED_MEDICAL.getName());
        results[1] = new ExpenseMetaDataFromZICPosition(zic
            .getFuneralExpenses(), ExpenseType.EXPENSE_TYPE_FUNERAL_AND_BURIAL.getName());
        results[2] = new ExpenseMetaDataFromZICPosition(zic
            .getEducationalExpenses(), ExpenseType.EXPENSE_TYPE_COLLEGE_AND_VOCATION.getName());
        return results;
    }

    private IncomeMetaData[] buildIncome(ZIC zic, ZMT zmt)
    {
        IncomeMetaData[] results = new IncomeMetaData[10];
        //The data for ZIC 3 and ZIC 9 will have different values depending on the Means test version 
        //Pre Feb 2005 format
        if("0".equals(zmt.getMeansTestVersion()))
        {
            results[0] = new IncomeMetaDataFromZICPosition(zic.getSocialSecurityOrGrossIncome(),
                    IncomeType.INCOME_TYPE_SOCIAL_SECURITY.getName());
            results[9] = new IncomeMetaDataFromZICPosition(zic.getOtherIncome(),
                    IncomeType.INCOME_TYPE_TOTAL_ALL_OTHER_INCOME.getName());            
            
        }else  
        {	//Feb 2005
            results[0] = new IncomeMetaDataFromZICPosition(zic.getSocialSecurityOrGrossIncome(),
                    IncomeType.INCOME_TYPE_TOTAL_ALL_OTHER_INCOME.getName());
            results[9] = new IncomeMetaDataFromZICPosition(zic.getOtherIncome(),
                    IncomeType.INCOME_TYPE_FARM_RANCH_PROPERTY_OR_BUSINESS_INCOME.getName());            
        }
        //Temporary till VISTA sends us teh new type 
        results[1] = new IncomeMetaDataFromZICPosition(zic.getCivilService(),
                IncomeType.INCOME_TYPE_CIVIL_SERVICE.getName());
        results[2] = new IncomeMetaDataFromZICPosition(zic
            .getRailroadRetirement(), IncomeType.INCOME_TYPE_RAILROAD_RETIREMENT.getName());
        results[3] = new IncomeMetaDataFromZICPosition(zic
            .getMilitaryRetirement(), IncomeType.INCOME_TYPE_MILITARY_RETIREMENT.getName());
        results[4] = new IncomeMetaDataFromZICPosition(zic
            .getUnemploymentCompensation(), IncomeType.INCOME_TYPE_UNEMPLOYMENT_COMPENSATION.getName());
        results[5] = new IncomeMetaDataFromZICPosition(
            zic.getOtherRetirement(), IncomeType.INCOME_TYPE_OTHER_RETIREMENT.getName());
        results[6] = new IncomeMetaDataFromZICPosition(zic
            .getEmploymentIncome(), IncomeType.INCOME_TYPE_TOTAL_INCOME_FROM_EMPLOYMENT.getName());
        results[7] = new IncomeMetaDataFromZICPosition(zic
            .getInterestDividendAnnuity(), IncomeType.INCOME_TYPE_INTEREST_DIVIDEND_ANNUITY.getName());
        results[8] = new IncomeMetaDataFromZICPosition(zic
            .getWorkersCompBlackLung(), IncomeType.INCOME_TYPE_WORKERS_COMP_BLACK_LUNG.getName());

        return results;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.FinancialInformationMetaData#getAssets()
     */
    public AssetMetaData[] getAssets()
    {
        return this.assets;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.FinancialInformationMetaData#getDebt()
     */
    public DebtMetaData getDebt()
    {
        return this.debt;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.FinancialInformationMetaData#getExpenses()
     */
    public ExpenseMetaData[] getExpenses()
    {
        return this.expenses;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.FinancialInformationMetaData#getIncome()
     */
    public IncomeMetaData[] getIncome()
    {
        return this.income;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.FinancialInformationMetaData#getIncomeYear()
     */
    public String getIncomeYear()
    {
        return (this.zic == null) ? null : this.zic.getIncomeYear();
    }
}