/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.esr.common.builder.entity.AssetMetaData;
import gov.va.med.esr.common.builder.entity.DebtMetaData;
import gov.va.med.esr.common.builder.entity.ExpenseMetaData;
import gov.va.med.esr.common.builder.entity.FinancialInformationMetaData;
import gov.va.med.esr.common.builder.entity.IncomeMetaData;
import gov.va.med.esr.service.external.person.BaseFinancialInfo;


public abstract class FinancialInformationMetaDataFromIVM
    extends AbstractMetaData
    implements FinancialInformationMetaData
{
    private BaseFinancialInfo baseFinancialInfo;
    private String incomeYear;

    private AssetMetaData[] assets;
    private DebtMetaData debt;
    private ExpenseMetaData[] expenses;
    private IncomeMetaData[] income;

    public FinancialInformationMetaDataFromIVM(BaseFinancialInfo baseFinancialInfo, String incomeYear)
    {
        super();
        this.baseFinancialInfo = baseFinancialInfo;
        this.incomeYear = incomeYear;
    }
    


    private AssetMetaData[] buildAssets()
    {
        return null;
    }

    protected ExpenseMetaData[] buildExpenses()
    {
        return null;
    }

    private IncomeMetaData[] buildIncome()
    {
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.FinancialInformationMetaData#getAssets()
     */
    public AssetMetaData[] getAssets()
    {
        return this.assets;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.FinancialInformationMetaData#getDebt()
     */
    public DebtMetaData getDebt()
    {
        return this.debt;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.FinancialInformationMetaData#getExpenses()
     */
    public ExpenseMetaData[] getExpenses()
    {
        return this.expenses;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.FinancialInformationMetaData#getIncome()
     */
    public IncomeMetaData[] getIncome()
    {
        return this.income;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.FinancialInformationMetaData#getIncomeYear()
     */
    public String getIncomeYear()
    {
        return this.incomeYear;
    }
}