package gov.va.med.esr.common.builder.entity.metaData;

import gov.va.med.esr.common.builder.datatype.metadata.CE;
import gov.va.med.esr.common.builder.entity.FeeBasisMetaData;
import gov.va.med.esr.common.model.ee.FeeBasis;
import gov.va.med.fw.hl7.segment.MSH;
import gov.va.med.fw.hl7.segment.ZFE;

/**
 * Extracts Fee Basis related data from ZFE segment
 * 
 * @author Rajiv Patnaik
 * Created on Feb 14, 2006
 * @version 1.0
 * 
 * Copyright  2006 VHA. All rights reserved
 */
public class FeeBasisMetaDataFromZFE extends AbstractMetaData implements
        FeeBasisMetaData
{
    
    
    private FeeBasis entity;
    private CE treatmentCode;
    private CE feeBasisProgram;
    private MSH msh;
    private ZFE zfe;
    
    
    public FeeBasisMetaDataFromZFE(ZFE zfe, MSH msh)
    {
        super();
        this.msh = msh;
        this.zfe = zfe;
        
        this.feeBasisProgram= (zfe== null) ? null : CE
                .create(zfe.getFeeBasisProgram(), zfe.getComponentDelimiter());
        this.treatmentCode= (zfe== null) ? null : CE
                .create(zfe.getTreatmentCode(), zfe.getComponentDelimiter());
        
    }    
    
    /* (non-Javadoc)
     * @see gov.va.med.esr.common.builder.entity.FeeBasisMetaData#getEntity()
     */
    public FeeBasis getEntity()
    {
        return entity;
    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.common.builder.entity.FeeBasisMetaData#setEntity(gov.va.med.esr.common.model.ee.FeeBasis)
     */
    public void setEntity(FeeBasis entity)
    {
        this.entity = entity;

    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.common.builder.entity.FeeBasisMetaData#getAuthorizationFromDate()
     */
    public String getAuthorizationFromDate()
    {
        return (zfe == null ? null : zfe.getAuthorizationFromDate());
    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.common.builder.entity.FeeBasisMetaData#getAuthorizationToDate()
     */
    public String getAuthorizationToDate()
    {
        return (zfe == null ? null : zfe.getAuthorizationToDate());
    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.common.builder.entity.FeeBasisMetaData#getFeeBasisProgram()
     */
    public String getFeeBasisProgram()
    {
        return (this.feeBasisProgram == null) ? null : super.getValue(this.feeBasisProgram
                .getID());
    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.common.builder.entity.FeeBasisMetaData#getReportSite()
     */
    public String getReportSite()
    {
        return (msh == null ? null : msh.getSendingFacility());
    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.common.builder.entity.FeeBasisMetaData#getTreatmentTypeCode()
     */
    public String getTreatmentTypeCode()
    {
        return (this.treatmentCode == null) ? null : super.getValue(this.treatmentCode
                .getID());
    }

}
