/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes

// Common Classes
import gov.va.med.esr.common.builder.datatype.metadata.CE;
import gov.va.med.esr.common.builder.entity.EthnicityMetaData;
import gov.va.med.esr.common.model.person.Ethnicity;
import gov.va.med.fw.hl7.constants.DelimeterConstants;

// Messaging Classes

/**
 * Ethnicity is defined in PID-22: for example "2186-5-SLF~~0189~2186-5~~CDC"
 *
 * The current definition of the PID segment lists Race as sequence 10 and

   Ethnicity as sequence 22.  Both fields have a data type of composite element

   (CE), which is defined as a field broken down by 6 components.  Because this

   data type does not allow for the ability to encode the collection method,

   the values sent will be encoded with the collection method.  These values

   will be placed into the first triplet (components 1 to 3).

 

   The HL7 standard states that the second triplet (components 4 to 6) is

   reserved for governmentally assigned codes.  For our purposes, we will use

   the CDC values in the second triplet.  Note that the collection method is

   not carried/implied within the second triplet.

 *
 */
public class EthnicityMetaDataFromCE
    extends AbstractMetaData
    implements EthnicityMetaData
{
    /**
     * Encoding field delimiter for Ethnicity
     */
    private static final String ETHNICITY_ENCODING_DELIMITER = "-";

    private Ethnicity entity;

    private CE ce;
    
    private String ethnicityType = null;
    
    private String collectionMethod = null;
    
    public EthnicityMetaDataFromCE(CE ce)
    {
        super();

        this.ce = ce;
        
        parseIDField();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.EthnicityMetaData#getEntity()
     */
    public Ethnicity getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.EthnicityMetaData#setEntity(gov.va.med.esr.common.model.person.Name)
     */
    public void setEntity(Ethnicity entity)
    {
        this.entity = entity;
    }

    
    /*
     * The ID component should contain the ethnicity type encoded with the collection method:
     * "2186-5-SLF"
     */
    private void parseIDField() {
        String ID = (this.ce == null) ? null : super.getValue(this.ce.getID());
        if (ID != null && ID.length() > 0) {
            
            // The Ethnicity Type should be the substring before the last delimiter "-"
            int delimiterIndex = ID.lastIndexOf(ETHNICITY_ENCODING_DELIMITER);
            
            if (delimiterIndex != -1) {
            setEthnicityType(ID.substring(0, delimiterIndex));
            setCollectionMethod(ID.substring(delimiterIndex+1));
            }
            else 
                setEthnicityType(ID);
        }   
    }
    
    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.EthnicityMetaData#getEthnicityType()
     */
    public String getEthnicityType() {
         return ethnicityType;
    }

    private void setEthnicityType(String ethnicityType) {
        this.ethnicityType = ethnicityType;
    }
    
    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.EthnicityMetaData#getCollectionMethod()
     */
    public String getCollectionMethod() {
        return this.collectionMethod;
    }

    private void setCollectionMethod(String collectionMethod) {
        this.collectionMethod = collectionMethod;
    }

 }