/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.ZEL;

// Common Classes
import gov.va.med.esr.common.builder.entity.EnvironmentalContaminationExposureMetaData;
import gov.va.med.esr.common.model.ee.EnvironmentalContaminationExposure;

// Messaging Classes

/**
 * @author Martin Francisco
 */
public class EnvironmentalContaminationExposureMetaDataFromZEL
    extends AbstractMetaData
    implements EnvironmentalContaminationExposureMetaData
{
    private EnvironmentalContaminationExposure entity;

    private ZEL zel;

    public EnvironmentalContaminationExposureMetaDataFromZEL(ZEL zel)
    {
        super();

        this.zel = zel;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.EnvironmentalContaminationExposureMetaData#getEntity()
     */
    public EnvironmentalContaminationExposure getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.EnvironmentalContaminationExposureMetaData#setEntity(gov.va.med.esr.common.model.ee.EnvironmentalContaminationExposure)
     */
    public void setEntity(EnvironmentalContaminationExposure entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.EnvironmentalContaminationExposureMetaData#getIndicator()
     */
    public String getIndicator()
    {
        return (this.zel == null) ? null : this.zel
            .getEnvironmentalContaminants();
    }
}