/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes

// Common Classes
import gov.va.med.fw.hl7.segment.ZEM;
import gov.va.med.esr.common.builder.datatype.metadata.AD;
import gov.va.med.esr.common.builder.entity.AddressMetaData;
import gov.va.med.esr.common.builder.entity.EmploymentMetaData;
import gov.va.med.esr.common.model.person.Employment;

// Messaging Classes

public class EmploymentMetaDataFromZEM
    extends AbstractMetaData
    implements EmploymentMetaData
{
    private Employment entity;

    private ZEM zem;

    private AddressMetaData address;

    public EmploymentMetaDataFromZEM(ZEM zem)
    {
        super();

        this.zem = zem;
        
        this.address = (zem == null) ? null : new AddressMetaDataFromAD(AD
                .create(zem.getEmployerAddress(), zem
                    .getComponentDelimiter()));
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.EmploymentMetaData#getEntity()
     */
    public Employment getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.EmploymentMetaData#setEntity(gov.va.med.esr.common.model.person.Employment)
     */
    public void setEntity(Employment entity)
    {
        this.entity = entity;
    }
 
    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.EmploymentMetaData#getEmploymentStatus()
     */
    public String getEmploymentStatus()
    {
        return (this.zem == null) ? null : this.zem.getEmploymentStatus();
    }

    public String getEmployerName() {
        return (this.zem == null) ? null : this.zem.getEmployerName();
     }

    public String getEmployerPhone() {
        return (this.zem == null) ? null : this.zem.getEmployerPhoneNumber();
    }

    public String getOccupation() {
        return (this.zem == null) ? null : this.zem.getOccupation();
    }

    public AddressMetaData getAddress()
    {
        return this.address;
    }

    public String getRetirementDate() {
        return (this.zem == null) ? null : this.zem.getRetirementDate();
    }
}