package gov.va.med.esr.common.builder.entity.metaData;

import gov.va.med.esr.common.builder.datatype.metadata.EI;
import gov.va.med.esr.common.builder.datatype.metadata.XTN;
import gov.va.med.esr.common.builder.entity.EmailMetaData;
import gov.va.med.esr.common.model.party.Email;
import gov.va.med.fw.hl7.segment.RF1;

/**
 * Email metadata from a XTN datatype
 * 
 * @author Rajiv Patnaik Created on Jan 27, 2006
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public class EmailMetaDataFromXTN extends AbstractMetaData implements
        EmailMetaData
{
    private Email entity;

    private XTN xtn;

    private String type;

    private RF1 rf1;

    private EI referralID;

    public EmailMetaDataFromXTN(XTN xtn, RF1 rf1)
    {
        super();
        this.xtn = xtn;
        this.rf1 = rf1;        
        this.referralID = (rf1 == null) ? null : EI.create(rf1
                .getOriginalReferralID(), rf1.getComponentDelimiter());         
    }


    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.PhoneMetaData#getEntity()
     */
    public Email getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.PhoneMetaData#setEntity(gov.va.med.esr.common.model.party.Phone)
     */
    public void setEntity(Email entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.common.builder.entity.EmailMetaData#getEmailAddress()
     */
    public String getEmailAddress()
    {
        return super.getValue((this.xtn == null) ? null : this.xtn
                .getEmailAddress());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.common.builder.entity.EmailMetaData#getType()
     */
    public String getType()
    {
        return this.type;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.common.builder.entity.EmailMetaData#getTelecomUseCode()
     */
    public String getTelecomUseCode()
    {
        return super
                .getValue((this.xtn == null) ? null : this.xtn.getUseCode());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.common.builder.entity.EmailMetaData#getChangeSite()
     */
    public String getChangeSite()
    {
        return (this.referralID == null) ? null : super
                .getValue(this.referralID.getEntityID());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.common.builder.entity.EmailMetaData#getChangeSource()
     */
    public String getChangeSource()
    {
        return (this.referralID == null) ? null : super
                .getValue(this.referralID.getNamespaceID());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.common.builder.entity.EmailMetaData#getChangeDate()
     */
    public String getChangeDate()
    {
        return (this.rf1 == null) ? null : this.rf1
                .getEffectiveDate();
    }

}