/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.MSH;
import gov.va.med.fw.hl7.segment.ZEL;

// Common Classes
import gov.va.med.esr.common.builder.entity.EligibilityVerificationMetaData;
import gov.va.med.esr.common.model.ee.EligibilityVerification;

// Messaging Classes

public class EligibilityVerificationMetaDataFromZEL
    extends AbstractMetaData
    implements EligibilityVerificationMetaData
{
    private EligibilityVerification entity;

    private ZEL zel;
    private MSH msh;

    public EligibilityVerificationMetaDataFromZEL(ZEL zel, MSH msh)
    {
        super();
        
        this.zel = zel;
        this.msh = msh;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.EligibilityVerificationMetaData#getEntity()
     */
    public EligibilityVerification getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.EligibilityVerificationMetaData#setEntity(gov.va.med.esr.common.model.ee.EligibilityVerification)
     */
    public void setEntity(EligibilityVerification entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.EligibilityVerificationMetaData#getEligibilityStatus()
     */
    public String getEligibilityStatus()
    {
        return (this.zel == null) ? null : this.zel.getEligibilityStatus();
    }
    
    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.EligibilityVerificationMetaData#getEligibilityStatusDate()
     */
    public String getEligibilityStatusDate()
    {
        return (this.zel == null) ? null : this.zel.getEligibilityStatusDate();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.EligibilityVerificationMetaData#getVerificationFacility()
     */
    public String getVerificationFacility()
    {
        return (this.msh == null) ? null : this.msh.getSendingFacility();        
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.EligibilityVerificationMetaData#getVerificationMethod()
     */
    public String getVerificationMethod()
    {
        return (this.zel == null) ? null : this.zel
            .getEligibilityVerificationMethod();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.EligibilityVerificationMetaData#getVerificationSource()
     */
    public String getVerificationSource()
    {
        //NOTE: Not Sent
        return null;
    }
}