/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.ZDP;

// Common Classes
import gov.va.med.esr.common.builder.entity.DependentMetaData;
import gov.va.med.esr.common.model.person.Dependent;

// Messaging Classes

public class DependentMetaDataFromZDP
    extends RelationMetaDataFromZDP
    implements DependentMetaData
{
    private Dependent entity;

    private ZDP zdp;

    public DependentMetaDataFromZDP(ZDP zdp)
    {
        super(zdp);

        this.zdp = zdp;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.DependentMetaData#getEntity()
     */
    public Dependent getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.DependentMetaData#setEntity(gov.va.med.esr.common.model.person.Dependent)
     */
    public void setEntity(Dependent entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.DependentMetaData#getIncapableOfSelfSupport()
     */
    public String getIncapableOfSelfSupport()
    {
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.DependentMetaData#getRelationship()
     */
    public String getRelationship()
    {
        return (this.zdp == null) ? null : this.zdp.getRelationship();
    }

}