/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.ZDP;
import gov.va.med.fw.hl7.segment.ZIC;
import gov.va.med.fw.hl7.segment.ZIR;
import gov.va.med.fw.hl7.segment.ZMT;

// Common Classes
import gov.va.med.esr.common.builder.entity.DependentFinancialsMetaData;
import gov.va.med.esr.common.builder.entity.DependentMetaData;
import gov.va.med.esr.common.builder.entity.ExpenseMetaData;
import gov.va.med.esr.common.builder.entity.PersonMetaData;
import gov.va.med.esr.common.model.financials.DependentFinancials;
import gov.va.med.esr.common.model.lookup.ExpenseType;

// Messaging Classes

public class DependentFinancialsMetaDataFromZDP
    extends FinancialInformationMetaDataFromZIC
    implements DependentFinancialsMetaData
{
    private DependentFinancials entity;

    private ZIR zir;

    private PersonMetaData reportedOn;
    private DependentMetaData reportedOnDependent;

    public DependentFinancialsMetaDataFromZDP(ZDP zdp, ZIC zic, ZIR zir,ZMT zmt)
    {
        super(zic, zmt);

        this.zir = zir;

        this.reportedOnDependent = (zdp == null) ? null
            : new DependentMetaDataFromZDP(zdp);
    }

    
    /**
     * @see gov.va.med.esr.common.builder.entity.metaData.FinancialInformationMetaDataFromZIC#buildExpenses(gov.va.med.fw.hl7.segment.ZIC)
     */
    protected ExpenseMetaData[] buildExpenses(ZIC zic) {
        ExpenseMetaData[] results = new ExpenseMetaData[3];
        results[0] = new ExpenseMetaDataFromZICPosition(zic
            .getMedicalExpenses(), ExpenseType.EXPENSE_TYPE_ADJUSTED_MEDICAL.getName());
        results[1] = new ExpenseMetaDataFromZICPosition(zic
            .getFuneralExpenses(), ExpenseType.EXPENSE_TYPE_FUNERAL_AND_BURIAL.getName());
        results[2] = new ExpenseMetaDataFromZICPosition(zic
            .getEducationalExpenses(), ExpenseType.EXPENSE_TYPE_EDUCATIONAL_EXPENSES_BY_DEPENDENT.getName());
        return results;
    }


    /**
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.DependentFinancialsMetaData#getEntity()
     */
    public DependentFinancials getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.DependentFinancialsMetaData#setEntity(gov.va.med.esr.common.model.financials.DependentFinancials)
     */
    public void setEntity(DependentFinancials entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.DependentFinancialsMetaData#getAttendedSchool()
     */
    public String getAttendedSchool()
    {
        return (this.zir == null) ? null : this.zir.getDependentChildSchoolIndicator(); 
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.DependentFinancialsMetaData#getContributedToSupport()
     */
    public String getContributedToSupport()
    {
        return (this.zir == null) ? null : this.zir.getContributedToSupport();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.DependentFinancialsMetaData#getAmountContributedToSupport()
     */
    public String getAmountContributedToSupport()
    {
        return (this.zir == null) ? null : this.zir.getAmountContributedToSpouseDep();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.DependentFinancialsMetaData#getHasIncome()
     */
    public String getHasIncome()
    {
        return (this.zir == null) ? null : this.zir.getChildHadIncome();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.DependentFinancialsMetaData#getIncapableOfSelfSupport()
     */
    public String getIncapableOfSelfSupport()
    {
        return (this.zir == null) ? null : this.zir.getIncapableOfSelfSupport();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.DependentFinancialsMetaData#getIncomeAvailableToPatient()
     */
    public String getIncomeAvailableToPatient()
    {
        return (this.zir == null) ? null : this.zir.getIncomeAvailableToYou();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.DependentFinancialsMetaData#getLivedWithPatient()
     */
    public String getLivedWithPatient()
    {
        return (this.zir == null) ? null : this.zir.getLivedWithPatient();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.DependentFinancialsMetaData#getReportedOn()
     */
    public PersonMetaData getReportedOn()
    {
        return this.reportedOn;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.DependentFinancialsMetaData#getReportedOnDependent()
     */
    public DependentMetaData getReportedOnDependent()
    {
        return this.reportedOnDependent;
    }
}