/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes

// Common Classes
import gov.va.med.esr.common.builder.entity.DependentFinancialsMetaData;
import gov.va.med.esr.common.builder.entity.DependentMetaData;
import gov.va.med.esr.common.builder.entity.ExpenseMetaData;
import gov.va.med.esr.common.builder.entity.PersonMetaData;
import gov.va.med.esr.common.model.financials.DependentFinancials;
import gov.va.med.esr.service.external.person.DependentFinancialsInfo;


// Messaging Classes
public class DependentFinancialsMetaDataFromIVM
    extends FinancialInformationMetaDataFromIVM
    implements DependentFinancialsMetaData
{
    private DependentFinancials entity;

    private DependentFinancialsInfo depFinancialsInfo;

    private PersonMetaData reportedOn;
    private DependentMetaData reportedOnDependent;

    public DependentFinancialsMetaDataFromIVM(DependentFinancialsInfo depFinancialsInfo, String incomeYear)
    {
        super(depFinancialsInfo, incomeYear); 
        
        this.depFinancialsInfo = depFinancialsInfo;

        this.reportedOnDependent = (depFinancialsInfo == null) ? null
            : new DependentMetaDataFromIVM(depFinancialsInfo.getDependentInfo());
    }

    
    /**
     * @see gov.va.med.esr.common.builder.entity.metaData.FinancialInformationMetaDataFromZIC#buildExpenses(gov.va.med.fw.hl7.segment.ZIC)
     */
    protected ExpenseMetaData[] buildExpenses() {
        
        return null;
    }


    /**
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.DependentFinancialsMetaData#getEntity()
     */
    public DependentFinancials getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.DependentFinancialsMetaData#setEntity(gov.va.med.esr.common.model.financials.DependentFinancials)
     */
    public void setEntity(DependentFinancials entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.DependentFinancialsMetaData#getAttendedSchool()
     */
    public String getAttendedSchool()
    {
        return null; 
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.DependentFinancialsMetaData#getContributedToSupport()
     */
    public String getContributedToSupport()
    {
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.DependentFinancialsMetaData#getAmountContributedToSupport()
     */
    public String getAmountContributedToSupport()
    {
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.DependentFinancialsMetaData#getHasIncome()
     */
    public String getHasIncome()
    {
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.DependentFinancialsMetaData#getIncapableOfSelfSupport()
     */
    public String getIncapableOfSelfSupport()
    {
        return (this.depFinancialsInfo == null) ? null : this.depFinancialsInfo.getIncapableOfSelfSupport().toString();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.DependentFinancialsMetaData#getIncomeAvailableToPatient()
     */
    public String getIncomeAvailableToPatient()
    {
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.DependentFinancialsMetaData#getLivedWithPatient()
     */
    public String getLivedWithPatient()
    {
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.DependentFinancialsMetaData#getReportedOn()
     */
    public PersonMetaData getReportedOn()
    {
        return this.reportedOn;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.DependentFinancialsMetaData#getReportedOnDependent()
     */
    public DependentMetaData getReportedOnDependent()
    {
        return this.reportedOnDependent;
    }
}