/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.ZIC;

// Common Classes
import gov.va.med.esr.common.builder.entity.DebtMetaData;
import gov.va.med.esr.common.model.financials.Debt;

// Messaging Classes

public class DebtMetaDataFromZIC
    extends AbstractMetaData
    implements DebtMetaData
{
    private Debt entity;

    private ZIC zic;

    public DebtMetaDataFromZIC(ZIC zic)
    {
        super();

        this.zic = zic;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.DebtMetaData#getEntity()
     */
    public Debt getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.DebtMetaData#setEntity(gov.va.med.esr.common.model.financials.Debt)
     */
    public void setEntity(Debt entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.DebtMetaData#getAmount()
     */
    public String getAmount()
    {
        return (this.zic == null) ? null : this.zic.getDebts();
    }
}