/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.MSH;
import gov.va.med.fw.hl7.segment.ZPD;

// Common Classes
import gov.va.med.esr.common.builder.entity.DeathRecordMetaData;
import gov.va.med.esr.common.model.person.DeathRecord;

// Messaging Classes

public class DeathRecordMetaDataFromZPD
    extends AbstractMetaData
    implements DeathRecordMetaData
{
    private DeathRecord entity;

    private ZPD zpd;
    private MSH msh;
    private boolean lazarus;

    public DeathRecordMetaDataFromZPD(ZPD zpd, MSH msh, boolean lazarus)
    {
        super();

        this.zpd = zpd;
        this.msh = msh;
        this.lazarus = lazarus;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.DeathRecordMetaData#getEntity()
     */
    public DeathRecord getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.DeathRecordMetaData#setEntity(gov.va.med.esr.common.model.person.DeathRecord)
     */
    public void setEntity(DeathRecord entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.DeathRecordMetaData#getDataSource()
     */
    public String getDataSource()
    {
        return (this.zpd == null) ? null : this.zpd.getNotificationSource();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.DeathRecordMetaData#getDeathDate()
     */
    public String getDeathDate()
    {
        return ((this.zpd == null) || this.lazarus) ? null : this.zpd
            .getDeathDate();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.DeathRecordMetaData#getDeathReportDate()
     */
    public String getDeathReportDate()
    {
        return (this.zpd == null) ? null : this.zpd.getLastModifiedDate();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.DeathRecordMetaData#getFacilityReceived()
     */
    public String getFacilityReceived()
    {
        return (this.msh == null) ? null : this.msh.getSendingFacility();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.DeathRecordMetaData#getLazarusDate()
     */
    public String getLazarusDate()
    {
        return ((this.zpd == null) || !this.lazarus) ? null : this.zpd
            .getDeathDate();
    }
}