/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.ZMH;

// Common Classes
import gov.va.med.esr.common.builder.datatype.metadata.CE;
import gov.va.med.esr.common.builder.datatype.metadata.DR;
import gov.va.med.esr.common.builder.datatype.metadata.TS;
import gov.va.med.esr.common.builder.entity.ConflictExperienceMetaData;
import gov.va.med.esr.common.model.ee.ConflictExperience;

// Messaging Classes

public class ConflictExperienceMetaDataFromZMH
    extends AbstractMetaData
    implements ConflictExperienceMetaData
{
    private ConflictExperience entity;

    private ZMH zmh;

    private CE indicator;
    private DR dateRange;

    public ConflictExperienceMetaDataFromZMH(ZMH zmh)
    {
        super();

        this.zmh = zmh;

        this.indicator = (zmh == null) ? null : CE.create(zmh
            .getServiceIndicator(), zmh.getComponentDelimiter());
        this.dateRange = (zmh == null) ? null : DR.create(zmh
            .getServiceEntryDateAndServiceSeparationDate(), zmh
            .getComponentDelimiter(), zmh.getSubComponentDelimiter());
    }

    private String getValueFromTS(TS value)
    {
        return (value == null) ? null : super.getValue(value.getDateTime());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.ConflictExperienceMetaData#getEntity()
     */
    public ConflictExperience getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.ConflictExperienceMetaData#setEntity(gov.va.med.esr.common.model.ee.ConflictExperience)
     */
    public void setEntity(ConflictExperience entity)
    {
        this.entity = entity;
    
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.ConflictExperienceMetaData#getConflict()
     */
    public String getConflict()
    {
        String militaryHistoryType = (this.zmh == null) ? null : this.zmh.getMilitaryHistoryType();
        boolean isCombatExperience = MetaDataConstants.COMBAT_EXPERIENCE.equals(militaryHistoryType);
        
        String conflictLocation = null;
        //For combat experience, the location is in the ServiceIndicator - 2 
        if(isCombatExperience)
        {
            conflictLocation = (this.indicator == null) ? null : super.getValue(this.indicator
                    .getText());
        }else
        {
            conflictLocation = militaryHistoryType;
        }
        return conflictLocation;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.ConflictExperienceMetaData#getEndDate()
     */
    
    public String getEndDate()
    {
        return (this.dateRange == null) ? null : this
            .getValueFromTS(this.dateRange.getEndDateTime());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.ConflictExperienceMetaData#getIndicator()
     */
    public String getIndicator()
    {
        return (this.indicator == null) ? null : super.getValue(this.indicator
            .getID());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.ConflictExperienceMetaData#getStartDate()
     */
    public String getStartDate()
    {
        return (this.dateRange == null) ? null : this
            .getValueFromTS(this.dateRange.getStartDateTime());
    }
}