/**
 * 
 */
package gov.va.med.esr.common.builder.entity.metaData;

import gov.va.med.fw.hl7.segment.ZMH;

import gov.va.med.esr.common.builder.datatype.metadata.CE;
import gov.va.med.esr.common.builder.datatype.metadata.DR;
import gov.va.med.esr.common.builder.datatype.metadata.TS;
import gov.va.med.esr.common.builder.entity.CombatEpisodeMetaData;
import gov.va.med.esr.common.model.ee.CombatEpisode;

/**
 * @author DNS   KATIKM
 *
 */
public class CombatEpisodeMetaDataFromZMH extends AbstractMetaData 
	implements CombatEpisodeMetaData {

	private CombatEpisode entity = null;
    private ZMH zmh;
    private CE indicator;
    private DR dateRange;
    
	public CombatEpisodeMetaDataFromZMH(ZMH zmh) {
		super();
	    this.zmh = zmh;

	    this.indicator = (zmh == null) ? null : CE.create(zmh
	        .getServiceIndicator(), zmh.getComponentDelimiter());
	    this.dateRange = (zmh == null) ? null : DR.create(zmh
	        .getServiceEntryDateAndServiceSeparationDate(), zmh
	        .getComponentDelimiter(), zmh.getSubComponentDelimiter());
	}

	/* (non-Javadoc)
	 * @see gov.va.med.esr.common.builder.entity.CombatEpisodeMetaData#getEntity()
	 */
	public CombatEpisode getEntity() {
		return this.entity;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.esr.common.builder.entity.CombatEpisodeMetaData#setEntity(gov.va.med.esr.common.model.ee.CombatEpisode)
	 */
	public void setEntity(CombatEpisode entity) {
		this.entity = entity;
	}

	/* (non-Javadoc) component 1
	 * @see gov.va.med.esr.common.builder.entity.CombatEpisodeMetaData#getConflictLocation()
	 */
	public String getConflictLocation() {
	    return (this.indicator == null) ? null : super.getValue(this.indicator
	        .getID());		
	}

	/* (non-Javadoc) component 2
	 * @see gov.va.med.esr.common.builder.entity.CombatEpisodeMetaData#getSource()
	 */
	public String getSource() {
	    return (this.indicator == null) ? null : super.getValue(this.indicator
		        .getText());
	}

	/* (non-Javadoc) component 3
	 * @see gov.va.med.esr.common.builder.entity.CombatEpisodeMetaData#getFacility()
	 */
	public String getFacility() {
	    return (this.indicator == null) ? null : super.getValue(this.indicator
		        .getText());
	}

	/* (non-Javadoc)
	 * @see gov.va.med.esr.common.builder.entity.CombatEpisodeMetaData#getStartDate()
	 */
	public String getStartDate() {
        return (this.dateRange == null) ? null :
            this.getValueFromTS(this.dateRange.getStartDateTime());
	}

	/* (non-Javadoc)
	 * @see gov.va.med.esr.common.builder.entity.CombatEpisodeMetaData#getEndDate()
	 */
	public String getEndDate() {
	    return (this.dateRange == null) ? null :
	        this.getValueFromTS(this.dateRange.getEndDateTime());		
	}
	
    private String getValueFromTS(TS value)
    {
        return (value == null) ? null : super.getValue(value.getDateTime());
    }
}
