/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes
import java.util.HashSet;
import java.util.List;
import java.util.Set;

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.ZCD;

// Common Classes
import gov.va.med.esr.common.builder.datatype.metadata.CE;
import gov.va.med.esr.common.builder.entity.CDConditionMetaData;
import gov.va.med.esr.common.builder.entity.CDDescriptorMetaData;
import gov.va.med.esr.common.builder.entity.CDDiagnosisMetaData;
import gov.va.med.esr.common.builder.entity.CDProcedureMetaData;
import gov.va.med.esr.common.builder.entity.CatastrophicDisabilityMetaData;
import gov.va.med.esr.common.builder.entity.RaceMetaData;
import gov.va.med.esr.common.model.ee.CatastrophicDisability;

// Messaging Classes

/**
 * @author Martin Francisco
 */
public class CatastrophicDisabilityMetaDataFromZCD
    extends AbstractMetaData
    implements CatastrophicDisabilityMetaData
{
    private CatastrophicDisability entity;

    private ZCD zcd;

    private CE ce;
    private CDConditionMetaData[] conditions;
    private CDDiagnosisMetaData[] diagnoses;
    private CDProcedureMetaData[] procedures;
    private CDDescriptorMetaData[] descriptors;

    public CatastrophicDisabilityMetaDataFromZCD(List zcds)
    {
        super();

        this.zcd = ((zcds == null) || zcds.isEmpty()) ? null : (ZCD)zcds.get(0);
        this.ce = (this.zcd == null) ? null : CE.create(this.zcd
            .getDeterminationMethod(), this.zcd.getComponentDelimiter());

        this.processZCDs(zcds);
    }

    private void processZCDs(List zcds)
    {
        int size = ((zcds == null) ? 0 : zcds.size());
        Set<CDConditionMetaDataFromZCD> conditionSet = new HashSet<CDConditionMetaDataFromZCD>(size);
        Set<CDDiagnosisMetaDataFromZCD> diagnosisSet = new HashSet<CDDiagnosisMetaDataFromZCD>(size);
        Set<CDProcedureMetaDataFromZCD> procedureSet = new HashSet<CDProcedureMetaDataFromZCD>(size);
        Set<CDDescriptorMetaDataFromCE> descriptorSet = new HashSet<CDDescriptorMetaDataFromCE>(size);

        for(int index = 0; index < size; index++)
        {
            ZCD zcdSeg = (ZCD)zcds.get(index); 
            
            if(this.isDescriptor(zcdSeg))
             {
                           
                CE[] data = CE.create(zcdSeg.getDescriptor(), zcdSeg.getRepeatDelimiter(),
                        zcdSeg.getComponentDelimiter());

                if ((data != null) && (data.length > 0))
                {
                   int dataSize = data.length;
                    
                   for (int dataIndex = 0; dataIndex < dataSize; dataIndex++)
                    {
                       descriptorSet.add( new CDDescriptorMetaDataFromCE(data[dataIndex]));
                    }
                 }
               }
            else if (this.getCatastrophicallyDisabled().equalsIgnoreCase("Y")) {
            
                if(this.isCondition(zcdSeg))
                {
                    
                    conditionSet.add(new CDConditionMetaDataFromZCD(zcdSeg));
                }
                if(this.isDiagnosis(zcdSeg))
                {
                    diagnosisSet.add(new CDDiagnosisMetaDataFromZCD(zcdSeg));
                }
                if(this.isProcedure(zcdSeg))
                {
                    procedureSet.add(new CDProcedureMetaDataFromZCD(zcdSeg));
                }
            }
  
        }

        this.conditions = new CDConditionMetaData[conditionSet.size()];
        this.diagnoses = new CDDiagnosisMetaData[diagnosisSet.size()];
        this.procedures = new CDProcedureMetaData[procedureSet.size()];
        this.descriptors = new CDDescriptorMetaData[descriptorSet.size()];
       

        this.conditions = (CDConditionMetaData[])conditionSet
            .toArray(this.conditions);
        this.diagnoses = (CDDiagnosisMetaData[])diagnosisSet
            .toArray(this.diagnoses);
        this.procedures = (CDProcedureMetaData[])procedureSet
            .toArray(this.procedures);
        this.descriptors = (CDDescriptorMetaData[])descriptorSet
        .toArray(this.descriptors);
        
    }

    private boolean isCondition(ZCD zcdSeg)
    {
        return (super.hasData(zcdSeg.getCondition()));
    }

    private boolean isDiagnosis(ZCD zcdSeg)
    {
        return (super.hasData(zcdSeg.getDiagnosis()));
    }

    private boolean isProcedure(ZCD zcdSeg)
    {
        return (super.hasData(zcdSeg.getProcedure()));
    }
    
    private boolean isDescriptor(ZCD zcdSeg)
    {
        return (super.hasData(zcdSeg.getDescriptor()));
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.CatastrophicDisabilityMetaData#getEntity()
     */
    public CatastrophicDisability getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.CatastrophicDisabilityMetaData#setEntity(gov.va.med.esr.common.model.ee.CatastrophicDisability)
     */
    public void setEntity(CatastrophicDisability entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.CatastrophicDisabilityMetaData#getCatastrophicallyDisabled()
     */
    public String getCatastrophicallyDisabled()
    {
        return (this.zcd == null) ? null : this.zcd
            .getCatastrophicallyDisabled();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.CatastrophicDisabilityMetaData#getConditions()
     */
    public CDConditionMetaData[] getConditions()
    {
        return this.conditions;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.CatastrophicDisabilityMetaData#getDeterminationMethod()
     */
    public String getDeterminationMethod()
    {
        return (this.ce == null) ? null : super.getValue(this.ce.getID());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.CatastrophicDisabilityMetaData#getDeterminedBy()
     */
    public String getDeterminedBy()
    {
        return (this.zcd == null) ? null : this.zcd.getDecidedBy();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.CatastrophicDisabilityMetaData#getDiagnoses()
     */
    public CDDiagnosisMetaData[] getDiagnoses()
    {
        return this.diagnoses;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.CatastrophicDisabilityMetaData#getProcedures()
     */
    public CDProcedureMetaData[] getProcedures()
    {
        return this.procedures;
    }
    
    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.CatastrophicDisabilityMetaData#getDescriptors()
     */
    public CDDescriptorMetaData[] getDescriptors()
    {
        return this.descriptors;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.CatastrophicDisabilityMetaData#getReviewDate()
     */
    public String getReviewDate()
    {
        return (this.zcd == null) ? null : this.zcd.getReviewDate();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.ClinicalDeterminationMetaData#getDeterminationDate()
     */
    public String getDeterminationDate()
    {
        return (this.zcd == null) ? null : this.zcd.getDecisionDate();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.ClinicalDeterminationMetaData#getDeterminationFacility()
     */
    public String getDeterminationFacility()
    {
        return (this.zcd == null) ? null : this.zcd.getDeterminationFacility();
    }
    
    /* (non-Javadoc)
     * @see gov.va.med.esr.messaging.builder.entity.CatastrophicDisabilityMetaData#getVeteranRequestedCDReviewDate()
     */
    public String getVeteranRequestedCDReviewDate()
    {
        return (this.zcd == null) ? null : this.zcd.getVeteranRequestedCDReviewDate();
    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.messaging.builder.entity.CatastrophicDisabilityMetaData#getFacilityInitiatedCDReviewDate()
     */
    public String getFacilityInitiatedCDReviewDate()
    {
        return (this.zcd == null) ? null : this.zcd.getFacilityInitiatedCDReviewDate();
    }
    
    /* (non-Javadoc)
     * @see gov.va.med.esr.messaging.builder.entity.CatastrophicDisabilityMetaData#getVeteranWasNotifiedCDDate()
     */
    public String getVeteranWasNotifiedCDDate()
    {
        return (this.zcd == null) ? null : this.zcd.getVeteranWasNotifiedCDDate();
    }
    
}