/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.ZEN;

// Common Classes
import gov.va.med.esr.common.builder.entity.CancelDeclineMetaData;
import gov.va.med.esr.common.model.ee.CancelDecline;

// Messaging Classes

public class CancelDeclineMetaDataFromZEN
    extends AbstractMetaData
    implements CancelDeclineMetaData
{
    private CancelDecline entity;

    private ZEN zen;

    public CancelDeclineMetaDataFromZEN(ZEN zen)
    {
        super();

        this.zen = zen;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.CancelDeclineMetaData#getEntity()
     */
    public CancelDecline getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.CancelDeclineMetaData#setEntity(gov.va.med.esr.common.model.ee.CancelDecline)
     */
    public void setEntity(CancelDecline entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.CancelDeclineMetaData#getEffectiveDate()
     */
    public String getEffectiveDate()
    {
        return (this.zen == null) ? null : this.zen.getEffectiveDate();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.CancelDeclineMetaData#getReason()
     */
    public String getReason()
    {
        return (this.zen == null) ? null : this.zen.getReason();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.CancelDeclineMetaData#getReasonNotProcessed()
     */
    public String getReasonNotProcessed()
    {
        //NOTE: Not Sent
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.CancelDeclineMetaData#getRemarks()
     */
    public String getRemarks()
    {
        return (this.zen == null) ? null : this.zen.getRemarks();
    }
}