	/********************************************************************
	 * Copyright  2015 VHA. All rights reserved
	 ********************************************************************/
	package gov.va.med.esr.common.builder.entity.metaData;

	// Java Classes

	// Library Classes

	import gov.va.med.esr.common.builder.entity.CampLejeuneVerificationMetaData;
    import gov.va.med.esr.common.model.ee.CampLejeuneVerification;
    // Framework Classes
    import gov.va.med.fw.hl7.segment.ZEL;

	// Common Classes


	// Messaging Classes

	/**
	 * @author DNS   ZHANGS
	 */
	public class CampLejeuneVerificationMetaDataFromZEL
	    extends AbstractMetaData
	    implements CampLejeuneVerificationMetaData
	{
	    private CampLejeuneVerification entity;

	    private ZEL zel;

	    public CampLejeuneVerificationMetaDataFromZEL(ZEL zel)
	    {
	        super();

	        this.zel = zel;
	    }

	    /*
	     * (non-Javadoc)
	     * 
	     * @see gov.va.med.esr.messaging.builder.entity.AgentOrangeExposureMetaData#getEntity()
	     */
	    public CampLejeuneVerification getEntity()
	    {
	        return this.entity;
	    }

	    /*
	     * (non-Javadoc)
	     * 
	     * @see gov.va.med.esr.messaging.builder.entity.CampLejeuneVerificationMetaData#setEntity(gov.va.med.esr.common.model.ee.CampLejeuneVerification)
	     */
	    public void setEntity(CampLejeuneVerification entity)
	    {
	        this.entity = entity;
	    }

	    /*
	     * (non-Javadoc)
	     * 
	     * @see gov.va.med.esr.messaging.builder.entity.CampLejeuneVerificationMetaData#getCLIndicator()
	     */
	    public String getCLIndicator()
	    {
	        return (this.zel == null) ? null : this.zel.getCampLejeuneIndicator();
	    }

	    /*
	     * (non-Javadoc)
	     * 
	     * @see gov.va.med.esr.messaging.builder.entity.CampLejeuneVerificationMetaData#getCLRegDate()
	     */
	    public String getCLRegDate()
	    {
	        return (this.zel == null) ? null : this.zel.getCampLejeuneRegDate();
	        
	    }
	    
	    /*
	     * (non-Javadoc)
	     * 
	     * @see gov.va.med.esr.messaging.builder.entity.CampLejeuneVerificationMetaData# getCLChangeSite()
	     */
	    public String  getCLChangeSite()
	    {
	        return (this.zel == null) ? null : this.zel.getCampLejeuneChangeSite();
	        
	    }
	    /*
	     * (non-Javadoc)
	     * 
	     * @see gov.va.med.esr.messaging.builder.entity.CampLejeuneVerificationMetaData# getCLChangeSource()
	     */
	    public String  getCLChangeSource()
	    {
	        return (this.zel == null) ? null : this.zel.getCampLejeuneSourceOfChange();
	        
	    }
	}
