/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.ZCD;

// Common Classes
import gov.va.med.esr.common.builder.datatype.metadata.CE;
import gov.va.med.esr.common.builder.entity.CDProcedureMetaData;
import gov.va.med.esr.common.model.ee.CDProcedure;

// Messaging Classes

/**
 * @author Martin Francisco
 */
public class CDProcedureMetaDataFromZCD
    extends AbstractMetaData
    implements CDProcedureMetaData
{
    private CDProcedure entity;

    private CE affectedExtremity;
    private CE procedure;

    public CDProcedureMetaDataFromZCD(ZCD zcd)
    {
        super();

        this.affectedExtremity = (zcd == null) ? null : CE.create(zcd
            .getAffectedExtremity(), zcd.getComponentDelimiter());
        this.procedure = (zcd == null) ? null : CE
            .create(zcd.getProcedure(), zcd.getComponentDelimiter());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.CDProcedureMetaData#getEntity()
     */
    public CDProcedure getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.CDProcedureMetaData#setEntity(gov.va.med.esr.common.model.ee.CDProcedure)
     */
    public void setEntity(CDProcedure entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.CDProcedureMetaData#getAffectedExtremity()
     */
    public String getAffectedExtremity()
    {
        return (this.affectedExtremity == null) ? null : super
            .getValue(this.affectedExtremity.getID());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.CDProcedureMetaData#getProcedure()
     */
    public String getProcedure()
    {
        return (this.procedure == null) ? null : super.getValue(this.procedure
            .getID());
    }
}