/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.ZCD;

// Common Classes
import gov.va.med.esr.common.builder.datatype.metadata.CE;
import gov.va.med.esr.common.builder.entity.CDDiagnosisMetaData;
import gov.va.med.esr.common.model.ee.CDDiagnosis;

// Messaging Classes

/**
 * @author Martin Francisco
 */
public class CDDiagnosisMetaDataFromZCD
    extends AbstractMetaData
    implements CDDiagnosisMetaData
{
    private CDDiagnosis entity;

    private CE diagnosis;

    public CDDiagnosisMetaDataFromZCD(ZCD zcd)
    {
        super();

        this.diagnosis = (zcd == null) ? null : CE
            .create(zcd.getDiagnosis(), zcd.getComponentDelimiter());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.CDDiagnosisMetaData#getEntity()
     */
    public CDDiagnosis getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.CDDiagnosisMetaData#setEntity(gov.va.med.esr.common.model.ee.CDDiagnosis)
     */
    public void setEntity(CDDiagnosis entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.CDDiagnosisMetaData#getDiagnosis()
     */
    public String getDiagnosis()
    {
        return (this.diagnosis == null) ? null : super.getValue(this.diagnosis
            .getID());
    }
}