/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.ZCD;

// Common Classes
import gov.va.med.esr.common.builder.datatype.metadata.CE;
import gov.va.med.esr.common.builder.entity.CDConditionMetaData;
import gov.va.med.esr.common.model.ee.CDCondition;

// Messaging Classes

/**
 * @author Martin Francisco
 */
public class CDConditionMetaDataFromZCD
    extends AbstractMetaData
    implements CDConditionMetaData
{
    private CDCondition entity;

    private ZCD zcd;

    private CE condition;
    private CE permanent;

    public CDConditionMetaDataFromZCD(ZCD zcd)
    {
        super();

        this.zcd = zcd;

        this.condition = (zcd == null) ? null : CE
            .create(zcd.getCondition(), zcd.getComponentDelimiter());
        this.permanent = (zcd == null) ? null : CE.create(zcd
            .getPermanentIndicator(), zcd.getComponentDelimiter());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.CDConditionMetaData#getEntity()
     */
    public CDCondition getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.CDConditionMetaData#setEntity(gov.va.med.esr.common.model.ee.CDCondition)
     */
    public void setEntity(CDCondition entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.CDConditionMetaData#getCondition()
     */
    public String getCondition()
    {
        return (this.condition == null) ? null : super.getValue(this.condition
            .getID());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.CDConditionMetaData#getPermanent()
     */
    public String getPermanent()
    {
        return (this.permanent == null) ? null : super.getValue(this.permanent
            .getID());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.CDConditionMetaData#getScore()
     */
    public String getScore()
    {
        return (this.zcd == null) ? null : this.zcd.getScore();
    }
}