/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.ZDP;

// Common Classes
import gov.va.med.esr.common.builder.entity.BirthRecordMetaData;
import gov.va.med.esr.common.model.person.BirthRecord;

// Messaging Classes

public class BirthRecordMetaDataFromZDP
    extends AbstractMetaData
    implements BirthRecordMetaData
{
    private BirthRecord entity;

    private ZDP zdp;

    public BirthRecordMetaDataFromZDP(ZDP zdp)
    {
        super();

        this.zdp = zdp;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.BirthRecordMetaData#getEntity()
     */
    public BirthRecord getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.BirthRecordMetaData#setEntity(gov.va.med.esr.common.model.person.BirthRecord)
     */
    public void setEntity(BirthRecord entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.BirthRecordMetaData#getBirthDate()
     */
    public String getBirthDate()
    {
        return (this.zdp == null) ? null : this.zdp.getBirthDate();
    }

    public String getMultipleBirth() {
        return null;
    }
}