/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.esr.common.builder.entity.BirthRecordMetaData;
import gov.va.med.esr.common.model.person.BirthRecord;
import gov.va.med.fw.hl7.segment.PID;

// Messaging Classes

public class BirthRecordMetaDataFromPID
    extends AbstractMetaData
    implements BirthRecordMetaData
{
    private BirthRecord entity;

    private PID pid;

     public BirthRecordMetaDataFromPID(PID pid)
    {
        super();

        this.pid = pid;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.BirthRecordMetaData#getEntity()
     */
    public BirthRecord getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.BirthRecordMetaData#setEntity(gov.va.med.esr.common.model.person.BirthRecord)
     */
    public void setEntity(BirthRecord entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.BirthRecordMetaData#getBirthDate()
     */
    public String getBirthDate()
    {
        return (this.pid == null) ? null : this.pid.getDOB();
    }

    public String getMultipleBirth() {
        return (this.pid == null) ? null : this.pid.getMultipleBirthIndicator();
   }
}