/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.ZBT;
import gov.va.med.fw.hl7.segment.ZIC;

// Common Classes
import gov.va.med.esr.common.builder.entity.BeneficiaryTravelMetaData;
import gov.va.med.esr.common.model.financials.BeneficiaryTravel;

// Messaging Classes

public class BeneficiaryTravelMetaDataFromZBT
    extends AbstractMetaData
    implements BeneficiaryTravelMetaData
{
    private BeneficiaryTravel entity;

    private ZBT zbt;
    private ZIC zic;
    private String facilityVisited;

    public BeneficiaryTravelMetaDataFromZBT(ZBT zbt, ZIC zic, String facilityVisited)
    {
        super();

        this.zbt = zbt;
        this.zic = zic;
        this.facilityVisited = facilityVisited;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.BeneficiaryTravelMetaData#getEntity()
     */
    public BeneficiaryTravel getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.BeneficiaryTravelMetaData#setEntity(gov.va.med.esr.common.model.financials.BeneficiaryTravel)
     */
    public void setEntity(BeneficiaryTravel entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.BeneficiaryTravelMetaData#getAmountCertified()
     */
    public String getAmountCertified()
    {
        return (this.zbt == null) ? null : this.zbt.getCertifiedAmount();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.BeneficiaryTravelMetaData#getClaimDate()
     */
    public String getClaimDate()
    {
        return (this.zbt == null) ? null : this.zbt.getTravelClaimDate();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.BeneficiaryTravelMetaData#getDateCertified()
     */
    public String getDateCertified()
    {
        return (this.zbt == null) ? null : this.zbt.getCertifiedDate();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.BeneficiaryTravelMetaData#getEligible()
     */
    public String getEligible()
    {
        return (this.zbt == null) ? null : this.zbt.getEligible();
    }

	/* (non-Javadoc)
	 * @see gov.va.med.esr.messaging.builder.entity.BeneficiaryTravelMetaData#getSite()
	 */
	public String getFacilityVisited() {
		return facilityVisited;
	}

    /* (non-Javadoc)
     * @see gov.va.med.esr.common.builder.entity.BeneficiaryTravelMetaData#getSiteYear()
     */
    public String getSiteYear()
    {
        return (this.zic == null) ? null : this.zic.getIncomeYear();
    }
}