/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.ZGD;

// Common Classes
import gov.va.med.esr.common.builder.datatype.metadata.AD;
import gov.va.med.esr.common.builder.datatype.metadata.TN;
import gov.va.med.esr.common.builder.entity.AddressMetaData;
import gov.va.med.esr.common.builder.entity.AssociationMetaData;
import gov.va.med.esr.common.builder.entity.NameMetaData;
import gov.va.med.esr.common.builder.entity.PhoneMetaData;
import gov.va.med.esr.common.model.person.Association;

// Messaging Classes

public class AssociationMetaDataFromZGD
    extends AbstractMetaData
    implements AssociationMetaData
{
    private Association entity; 

    private ZGD zgd;

    private AddressMetaData address;
    private PhoneMetaData homePhone; 

    public AssociationMetaDataFromZGD(ZGD zgd)
    {
        super();

        this.zgd = zgd;
        this.address = (zgd == null) ? null : new AddressMetaDataFromAD(AD
            .create(zgd.getGuardianAddress(), zgd.getComponentDelimiter()));
        this.homePhone = (zgd == null) ? null : new PhoneMetaDataFromTN(TN
            .create(zgd.getGuardianPhoneNumber()));
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AssociationMetaData#getEntity()
     */
    public Association getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AssociationMetaData#setEntity(gov.va.med.esr.common.model.person.Association)
     */
    public void setEntity(Association entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AssociationMetaData#getAddress()
     */
    public AddressMetaData getAddress()
    {
        return this.address;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AssociationMetaData#getHomePhone()
     */
    public PhoneMetaData getPrimaryPhone()
    {
        return this.homePhone;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AssociationMetaData#getOrganizationName()
     */
    public String getOrganizationName()
    {
        return (this.zgd == null) ? null : this.zgd.getGuardianInstitution();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AssociationMetaData#getRelationship()
     */
    public String getRelationship()
    {
        return (this.zgd == null) ? null : this.zgd.getGuardianRelationship();
    }
    
    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AssociationMetaData#getRepresentativeName()
     */
    public NameMetaData getContactName()
    {
        return null;
    }    

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AssociationMetaData#getRepresentativeName()
     */
    public String getGuardianName()
    {
        return (this.zgd == null) ? null : this.zgd.getGuardianName();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AssociationMetaData#getType()
     */
    public String getType()
    {
        return (this.zgd == null) ? null : this.zgd.getGuardianType();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AssociationMetaData#getWorkPhone()
     */
    public PhoneMetaData getAlternatePhone()
    {
        return null;
    }

    /* 
     * No last updated date for Guardian(Only contact in ZCT)
     * 
     * (non-Javadoc)
     * @see gov.va.med.esr.messaging.builder.entity.AssociationMetaData#getLastUpdateDate()
     */
    public String getLastUpdateDate()
    {
        return null;
    } 
    
    
}