/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.ZCT;

// Common Classes
import gov.va.med.esr.common.builder.datatype.metadata.AD;
import gov.va.med.esr.common.builder.datatype.metadata.TN;
import gov.va.med.esr.common.builder.entity.AddressMetaData;
import gov.va.med.esr.common.builder.entity.AssociationMetaData;
import gov.va.med.esr.common.builder.entity.NameMetaData;
import gov.va.med.esr.common.builder.entity.PhoneMetaData;
import gov.va.med.esr.common.model.person.Association;

// Messaging Classes

public class AssociationMetaDataFromZCT
    extends AbstractMetaData
    implements AssociationMetaData
{
    private Association entity;

    private ZCT zct;

    private AddressMetaData address;
    private PhoneMetaData homePhone;
    private NameMetaData contactName;
    private PhoneMetaData workPhone;

    public AssociationMetaDataFromZCT(ZCT zct)
    {
        super();

        this.zct = zct;
        this.address = (zct == null) ? null : new AddressMetaDataFromAD(AD
            .create(zct.getContactAddress(), zct.getComponentDelimiter()));
        this.homePhone = (zct == null) ? null : new PhoneMetaDataFromTN(TN
            .create(zct.getContactPhoneNumber()));
//      As per requirement, there is no explicit delete association. The signal is, if the 
        //incoming message has "" (double quote) then it is considered as delete assiciation.
//        if("".equals(zct.getContactName())) zct.setContactName("DELETEFLAG~DELETEFLAG~~~~~D");
        this.contactName = (zct == null) ? null : getNameMetaData(zct
                .getContactName(), zct.getRepeatDelimiter(), zct
                .getComponentDelimiter());
        this.workPhone = (zct == null) ? null : new PhoneMetaDataFromTN(TN
            .create(zct.getContactWorkPhoneNumber()));
        
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AssociationMetaData#getEntity()
     */
    public Association getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AssociationMetaData#setEntity(gov.va.med.esr.common.model.person.Association)
     */
    public void setEntity(Association entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AssociationMetaData#getAddress()
     */
    public AddressMetaData getAddress()
    {
        return this.address;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AssociationMetaData#getHomePhone()
     */
    public PhoneMetaData getPrimaryPhone()
    {
        return this.homePhone;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AssociationMetaData#getOrganizationName()
     */
    public String getOrganizationName()
    {
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AssociationMetaData#getRelationship()
     */
    public String getRelationship()
    {
        return (this.zct == null) ? null : this.zct.getContactRelationship();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AssociationMetaData#getRepresentativeName()
     */
    public NameMetaData getContactName()
    {
        return this.contactName;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AssociationMetaData#getRepresentativeName()
     */
    public String getGuardianName()
    {
        return null;
    }
    
    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AssociationMetaData#getType()
     */
    public String getType()
    {
        return (this.zct == null) ? null : this.zct.getContactType();     
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AssociationMetaData#getWorkPhone()
     */
    public PhoneMetaData getAlternatePhone()
    {
        return this.workPhone;
    }

    /** 
     * Added in I3 
     */
    public String getLastUpdateDate()
    {
        return (this.zct == null) ? null : this.zct.getLastUpdateDate();
    }
    
}