/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.ZEN;

// Common Classes
import gov.va.med.esr.common.builder.entity.ApplicationMetaData;
import gov.va.med.esr.common.model.ee.Application;

// Messaging Classes

public class ApplicationMetaDataFromZEN
    extends AbstractMetaData
    implements ApplicationMetaData
{
    private Application entity;

    private ZEN zen;

    public ApplicationMetaDataFromZEN(ZEN zen)
    {
        super();

        this.zen = zen;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.ApplicationMetaData#getEntity()
     */
    public Application getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.ApplicationMetaData#setEntity(gov.va.med.esr.common.model.ee.Application)
     */
    public void setEntity(Application entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.ApplicationMetaData#getApplicationDate()
     */
    public String getApplicationDate()
    {
        return (this.zen == null) ? null : this.zen
            .getEnrollmentApplicationDate();
    }

}