/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.ZEL;

// Common Classes
import gov.va.med.esr.common.builder.entity.AgentOrangeExposureMetaData;
import gov.va.med.esr.common.model.ee.AgentOrangeExposure;

// Messaging Classes

/**
 * @author Martin Francisco
 */
public class AgentOrangeExposureMetaDataFromZEL
    extends AbstractMetaData
    implements AgentOrangeExposureMetaData
{
    private AgentOrangeExposure entity;

    private ZEL zel;

    public AgentOrangeExposureMetaDataFromZEL(ZEL zel)
    {
        super();

        this.zel = zel;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AgentOrangeExposureMetaData#getEntity()
     */
    public AgentOrangeExposure getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AgentOrangeExposureMetaData#setEntity(gov.va.med.esr.common.model.ee.AgentOrangeExposure)
     */
    public void setEntity(AgentOrangeExposure entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AgentOrangeExposureMetaData#getIndicator()
     */
    public String getIndicator()
    {
        return (this.zel == null) ? null : this.zel.getAgentOrangeExposure();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AgentOrangeExposureMetaData#getLocation()
     */
    public String getLocation()
    {
        return (this.zel == null) ? null : this.zel
            .getAgentOrangeExposureLocation();
    }
}