/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.ZTA;

import gov.va.med.esr.common.builder.datatype.metadata.XAD;
import gov.va.med.esr.common.model.lookup.AddressType;

public class AddressMetaDataFromZTA
    extends AddressMetaDataFromXAD
{
    private ZTA zta;
    
    public AddressMetaDataFromZTA(XAD xad, ZTA zta)
    {
        super(xad);

        this.zta = zta;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AddressMetaData#getChangeDate()
     */
    public String getChangeDate()
    {
        return (this.zta == null) ? null : this.zta.getTemporaryAddressLastUpdatedDate();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AddressMetaData#getChangeSite()
     */
    public String getChangeSite()
    {
        return (this.zta == null) ? null : this.zta.getTemporaryAddressChangeSite();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AddressMetaData#getCounty()
     */
    public String getCounty()
    {
        return ((this.zta == null) || (this.zta.getTemporaryAddressCounty() == null)) ? super
            .getCounty()
            : this.zta.getTemporaryAddressCounty();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AddressMetaData#getType()
     */
    public String getType()
    {	
        return AddressType.CODE_TEMPORARY_CORRESPONDENCE_ADDRESS.getName();
    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.messaging.builder.entity.AddressMetaData#getEndDate()
     */
    public String getEndDate()
    {
        return (this.zta == null) ? null : this.zta
            .getTemporaryAddressEndDate();
    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.messaging.builder.entity.AddressMetaData#getStartDate()
     */
    public String getStartDate()
    {
        return (this.zta == null) ? null : this.zta
            .getTemporaryAddressStartDate();
    }
    
    public String getStatus() 
    {
    	return (this.zta == null) ? null : this.zta.getTemporaryAddressIndicator();
    }
    
    public String getTemporaryAddressPhoneNumber()
    {
        return (this.zta == null) ? null : this.zta
                .getTemporaryAddressPhoneNumber();
    }
    
}