/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes

// Common Classes
import gov.va.med.esr.common.builder.datatype.metadata.XAD;
import gov.va.med.esr.common.builder.entity.AddressMetaData;
import gov.va.med.esr.common.model.lookup.Country;
import gov.va.med.esr.common.model.party.Address;

// Messaging Class

/**
 * @author Martin Francisco
 */
public class AddressMetaDataFromXAD extends AbstractMetaData implements
        AddressMetaData
{
    private Address entity;

    private XAD xad;

    private String country;

    private String postalCode;

    private String province;

    private String state;

    private String zipCode;

    private String zipPlus4;

    private String startDate;

    private String endDate;
    
    private String status;

    public AddressMetaDataFromXAD(XAD xad)
    {
        super();

        this.xad = xad;

        if ((xad != null))
        {
            //Set the start and end dates from XAD segment
            setStartAndEndDates();

            this.country = super.getValue(xad.getCountryCode());

            if (Country.isUSAddress(this.country))
            {
                this.postalCode = null;
                this.province = null;
                this.state = super.getValue(xad.getState());
                this.processZipCode(super.getValue(xad.getZipCode()));
            } else
            {
                this.postalCode = super.getValue(xad.getZipCode());
                this.province = super.getValue(xad.getState());
                this.state = null;
                this.zipCode = null;
                this.zipPlus4 = null;
            }

        }
    }

    /**
     * Set the start and end dates from XAD segment
     *  
     */
    private void setStartAndEndDates()
    {
        if (xad != null)
        {
            //Start Date and End Date delimited by a ampersand(&)
            //e.g 20050808&20050818
            String startAndEndDateFromXAD = super.getValue(xad
                    .getAddressValidityRange());
            if (startAndEndDateFromXAD != null)
            {
                String[] dateComponents = startAndEndDateFromXAD
                        .split(XAD.START_AND_END_DATE_DELIMITER);
                this.startDate = (dateComponents == null ? null
                        : dateComponents.length > 0 ? dateComponents[0] : null);
                this.endDate = (dateComponents == null ? null
                        : dateComponents.length > 1 ? dateComponents[1] : null);
            }

        }

    }

    private void processZipCode(String value)
    {
        if (value == null)
        {
            this.zipCode = null;
            this.zipPlus4 = null;
        } else
        {
            String[] zipComponents = value.split("\\-");

            if (zipComponents.length == 1)
            {
                if (zipComponents[0].length() > 5)
                {
                    this.zipCode = zipComponents[0].substring(0, 5);
                    this.zipPlus4 = zipComponents[0].substring(5);
                } else
                {
                    this.zipCode = zipComponents[0];
                    this.zipPlus4 = null;
                }
            } else
            {
                this.zipCode = zipComponents[0];
                this.zipPlus4 = zipComponents[1];
            }
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AddressMetaData#getEntity()
     */
    public Address getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AddressMetaData#setEntity(gov.va.med.esr.common.model.party.Address)
     */
    public void setEntity(Address entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AddressMetaData#getChangeDate()
     */
    public String getChangeDate()
    {
        return getStartDate();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AddressMetaData#getChangeSite()
     */
    public String getChangeSite()
    {
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AddressMetaData#getChangeSource()
     */
    public String getChangeSource()
    {
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AddressMetaData#getCity()
     */
    public String getCity()
    {
        return super.getValue((this.xad == null) ? null : this.xad.getCity());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AddressMetaData#getCountry()
     */
    public String getCountry()
    {
        return this.country;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AddressMetaData#getCounty()
     */
    public String getCounty()
    {
        return super.getValue((this.xad == null) ? null : this.xad
                .getCountyParishCode());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AddressMetaData#getLine1()
     */
    public String getLine1()
    {
        return super.getValue((this.xad == null) ? null : this.xad
                .getStreetAddress());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AddressMetaData#getLine2()
     */
    public String getLine2()
    {
        return super.getValue((this.xad == null) ? null : this.xad
                .getOtherDesignation());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AddressMetaData#getLine3()
     */
    public String getLine3()
    {
        return super.getValue((this.xad == null) ? null : this.xad
                .getOtherGeographicDesignation());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AddressMetaData#getPostalCode()
     */
    public String getPostalCode()
    {
        return this.postalCode;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AddressMetaData#getProvince()
     */
    public String getProvince()
    {
        return this.province;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AddressMetaData#getState()
     */
    public String getState()
    {
        return this.state;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AddressMetaData#getType()
     */
    public String getType()
    {
        return super.getValue((this.xad == null) ? null : this.xad
                .getTypeCode());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AddressMetaData#getZipCode()
     */
    public String getZipCode()
    {
        return this.zipCode;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AddressMetaData#getZipPlus4()
     */
    public String getZipPlus4()
    {
        return this.zipPlus4;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AddressMetaData#getEndDate()
     */
    public String getEndDate()
    {
        return this.endDate;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AddressMetaData#getStartDate()
     */
    public String getStartDate()
    {
        return this.startDate;
    }

    public String getStatus() {
		return this.status;
	}

	public String getTemporaryAddressPhoneNumber()
    {
        return null;
    }
}