/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.hl7.segment.PID;
import gov.va.med.fw.hl7.segment.RF1;

// Common Classes

// Messaging Classes
import gov.va.med.esr.common.builder.datatype.metadata.EI;
import gov.va.med.esr.common.builder.datatype.metadata.XAD;

public class AddressMetaDataFromPID
    extends AddressMetaDataFromXAD
{
    private PID pid;
    private RF1 rf1;

    private EI referralID;

    public AddressMetaDataFromPID(XAD xad, PID pid, RF1 rf1)
    {
        super(xad);

        this.pid = pid;
        this.rf1 = rf1;

        this.referralID = (rf1 == null) ? null : EI.create(rf1
            .getOriginalReferralID(), rf1.getComponentDelimiter());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AddressMetaData#getChangeDate()
     */
    public String getChangeDate()
    {
        return (this.rf1 == null) ? null : this.rf1.getEffectiveDate();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AddressMetaData#getChangeSite()
     */
    public String getChangeSite()
    {
        return (this.referralID == null) ? null : super
            .getValue(this.referralID.getEntityID());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AddressMetaData#getChangeSource()
     */
    public String getChangeSource()
    {
        return (this.referralID == null) ? null : super
            .getValue(this.referralID.getNamespaceID());
    }
}