/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes

// Common Classes
import gov.va.med.esr.common.builder.datatype.metadata.AD;
import gov.va.med.esr.common.builder.entity.AddressMetaData;
import gov.va.med.esr.common.model.lookup.Country;
import gov.va.med.esr.common.model.party.Address;

/**
 * @author Martin Francisco
 * TODO RP 08/05 See if we can make this class abstract so that we don't have to have
 * uncessary dummy implementations of methods returning null 
 */
public class AddressMetaDataFromAD
    extends AbstractMetaData
    implements AddressMetaData
{
    private Address entity;

    private AD ad;

    private String country;
    private String postalCode;
    private String province;
    private String state;
    private String zipCode;
    private String zipPlus4;
    private String status;
    
    public AddressMetaDataFromAD(AD ad)
    {
        super();

        this.ad = ad;

        if(ad != null)
        {
            this.country = super.getValue(ad.getCountryCode());

            if (Country.isUSAddress(this.country))
            {
                this.postalCode = null;
                this.province = null;
                this.state = super.getValue(ad.getState());
                this.processZipCode(super.getValue(ad.getZipCode()));
            }
            else
            {
                this.postalCode = super.getValue(ad.getZipCode());
                this.province = super.getValue(ad.getState());
                this.state = null;
                this.zipCode = null;
                this.zipPlus4 = null;
            }
        }
        else
        {
            this.country = null;
            this.postalCode = null;
            this.province = null;
            this.state = null;
            this.zipCode = null;
            this.zipPlus4 = null;
        }
    }

    private void processZipCode(String value)
    {
        if(value == null)
        {
            this.zipCode = null;
            this.zipPlus4 = null;
        }
        else
        {
            String[] zipComponents = value.split("\\-");

            if(zipComponents.length == 1)
            {
                if(zipComponents[0].length() > 5)
                {
                    this.zipCode = zipComponents[0].substring(0, 5);
                    this.zipPlus4 = zipComponents[0].substring(5);
                }
                else
                {
                    this.zipCode = zipComponents[0];
                    this.zipPlus4 = null;
                }
            }
            else
            {
                this.zipCode = zipComponents[0];
                this.zipPlus4 = zipComponents[1];
            }
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AddressMetaData#getEntity()
     */
    public Address getEntity()
    {
        return this.entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AddressMetaData#setEntity(gov.va.med.esr.common.model.party.Address)
     */
    public void setEntity(Address entity)
    {
        this.entity = entity;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AddressMetaData#getChangeDate()
     */
    public String getChangeDate()
    {
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AddressMetaData#getChangeSite()
     */
    public String getChangeSite()
    {
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AddressMetaData#getChangeSource()
     */
    public String getChangeSource()
    {
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AddressMetaData#getCity()
     */
    public String getCity()
    {
        return super.getValue((this.ad == null) ? null : this.ad.getCity());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AddressMetaData#getCountry()
     */
    public String getCountry()
    {
        return this.country;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AddressMetaData#getCounty()
     */
    public String getCounty()
    {
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AddressMetaData#getLine1()
     */
    public String getLine1()
    {
        return super.getValue((this.ad == null) ? null : this.ad
            .getStreetAddress());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AddressMetaData#getLine2()
     */
    public String getLine2()
    {
        return super.getValue((this.ad == null) ? null : this.ad
            .getOtherDesignation());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AddressMetaData#getLine3()
     */
    public String getLine3()
    {
        return super.getValue((this.ad == null) ? null : this.ad
                .getOtherGeographicDesignation());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AddressMetaData#getPostalCode()
     */
    public String getPostalCode()
    {
        return this.postalCode;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AddressMetaData#getProvince()
     */
    public String getProvince()
    {
        return this.province;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AddressMetaData#getState()
     */
    public String getState()
    {
        return this.state;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AddressMetaData#getType()
     */
    public String getType()
    {
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AddressMetaData#getZipCode()
     */
    public String getZipCode()
    {
        return this.zipCode;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.builder.entity.AddressMetaData#getZipPlus4()
     */
    public String getZipPlus4()
    {
        return this.zipPlus4;
    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.messaging.builder.entity.AddressMetaData#getEndDate()
     */
    public String getEndDate()
    {
        return null;
    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.messaging.builder.entity.AddressMetaData#getStartDate()
     */
    public String getStartDate()
    {
        return null;
    }
    
    public String getStatus() {
		return this.status;
	}

	public String getTemporaryAddressPhoneNumber()
    {
        return null;
    }
}