/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity.metaData;

// Java Classes

// Library Classes

// Framework Classes

// Common Classes

// Messaging Classes
import java.util.Date;

import gov.va.med.esr.common.builder.datatype.metadata.SimpleTypeMetaData;
import gov.va.med.esr.common.builder.datatype.metadata.XPN;
import gov.va.med.esr.common.builder.entity.NameMetaData;
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.infra.ImpreciseDateUtils;

/**
 * @author Martin Francisco
 */
public class AbstractMetaData
{
    public AbstractMetaData()
    {
        super();
    }

    protected final String getValue(SimpleTypeMetaData data)
    {
        return (data == null) ? null : data.getValue();
    }

    protected final boolean hasData(String data)
    {
        return ((data != null) && (data.length() > 0) && !"\"\"".equals(data));
    } 
    
    protected NameMetaData getNameMetaData(String name, String repeatDelimiter,
            String componentDelimiter)
    {
        XPN[] data = XPN.create(name, repeatDelimiter, componentDelimiter);

        XPN nameXPN = null;

        if ((data != null) && (data.length > 0))
        {
            nameXPN = data[0];
        }
        return nameXPN == null ? null : new NameMetaDataFromXPN(nameXPN);
    }
    
	protected String getStandardDate(Date input) {
		// Use for situations where raw data contains real Dates. This method formats in
		// String that is suitable for conversion to Imprecise date. 
		ImpreciseDate date = input != null ? ImpreciseDateUtils.createImpreciseDateWithoutTime(input) : null;
		return date != null ? date.getStandardFormat() : null;			
	}  
}