/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity.lookup;

// Java Classes
import java.util.List;

// Library Classes

// Framework Classes
import gov.va.med.fw.model.lookup.AbstractLookup;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.builder.BuilderException;

// Messaging Classes

/**
 * @author Martin Francisco
 */
public class PartiallyMappedLookupDescriptionBuilder
    extends MappedLookupBuilder
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -411830319850135295L;

	/**
     * Default contructor.
     */
    public PartiallyMappedLookupDescriptionBuilder()
    {
        super();
    }

    protected AbstractLookup doBuild(String input) throws BuilderException
    {
        String tempDescription = super.translateInput(input);
        String esrDescription = (tempDescription == null) ? input
            : tempDescription;

        if(esrDescription == null)
        {
            return super.buildDefaultOnNull();
        }
        else
        {
            try
            {
                List list = super.getLookupService().findAll(super
                    .getLookupType());

                for(int index = 0; index < list.size(); index++)
                {
                    AbstractLookup item = (AbstractLookup)list
                        .get(index);
                    if(esrDescription.equals(item.getDescription()))
                    {
                        return item;
                    }
                }
                return super.buildDefaultOnException(true, null);
            }
            catch(ServiceException e)
            {
                throw new BuilderException(e);
            }
        }
    }
}