/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity.lookup;

// Java Classes
import java.util.Map;

// Library Classes

// Framework Classes
import gov.va.med.fw.model.lookup.AbstractLookup;
import gov.va.med.fw.util.builder.BuilderException;

// Messaging Classes

/**
 * @author Martin Francisco
 */
public class MappedLookupBuilder
    extends AbstractLookupBuilder
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 4962516755193025108L;
	private Map codeMap;

    /**
     * Default contructor.
     */
    public MappedLookupBuilder()
    {
        super();
    }

    public Map getCodeMap()
    {
        return this.codeMap;
    }

    public void setCodeMap(Map codeMap)
    {
        this.codeMap = codeMap;
    }

    protected AbstractLookup doBuild(String input) throws BuilderException
    {
        return super.getByCode(this.translateInput(input));
    }

    protected String translateInput(String input)
    {
        return (String)this.codeMap.get(input);
    }
}