/*******************************************************************************
 * Copyright  2004 EDS. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.builder.entity;

// Java Classes
import gov.va.med.esr.common.builder.entity.metaData.MonetaryBenefitAwardMetaDataFromZEL;
import gov.va.med.esr.common.model.ee.MonetaryBenefit;
import gov.va.med.esr.common.model.ee.MonetaryBenefitAward;
import gov.va.med.esr.common.model.ee.Pension;
import gov.va.med.esr.common.model.lookup.MonetaryBenefitType;
import gov.va.med.esr.common.model.lookup.PensionReasonCode;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.fw.hl7.HL7Message;
import gov.va.med.fw.hl7.InvalidMessageException;
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;

import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

// Messaging Classess

/**
 * Class that builds the application from a message.
 * 
 * @author Carlos Ruiz
 * @version 1.0
 */
public class VAPensionBuilder extends EntityBuilder {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -7222898023852297548L;

	private Builder typeBuilder;
	private Builder pensionReasonCodeBuilder;

	/**
	 * Default constructor.
	 */
	public VAPensionBuilder() {
		super();
	}

	public Builder getPensionReasonCodeBuilder() {
		return this.pensionReasonCodeBuilder;
	}

	public void setPensionReasonCodeBuilder(Builder pensionReasonCodeBuilder) {
		this.pensionReasonCodeBuilder = pensionReasonCodeBuilder;
	}

	
	public Builder getTypeBuilder() {
		return typeBuilder;
	}

	public void setTypeBuilder(Builder typeBuilder) {
		this.typeBuilder = typeBuilder;
	}

	/*	public MonetaryBenefitAward build(MonetaryBenefitAwardMetaData metaData)
		throws BuilderException {
		
		MonetaryBenefitAward input = metaData.getEntity();
		MonetaryBenefitAward output = (input == null) ? new MonetaryBenefitAward()	: input;
		transfer(output, metaData);
		return shouldKeep( output.getCheckAmount() ) ? output : null;
	}*/
	public MonetaryBenefitAward build(VAPensionMetaData metaData)
	throws BuilderException 
	{
		MonetaryBenefitAward input = metaData.getEntity();
		MonetaryBenefitAward output = (input == null) ? new MonetaryBenefitAward()	: input;
		transfer(output, metaData);

		return output;
	}
	


	private void transfer(MonetaryBenefitAward input,
			VAPensionMetaData metaData) throws BuilderException {

		MonetaryBenefit ben = input.getVAPension();
		if (ben == null)
		{
			ben = new MonetaryBenefit();
			ben.setType((MonetaryBenefitType)this.typeBuilder.build(MonetaryBenefitType.CODE_VA_PENSION.getCode()));
			input.addMonetaryBenefit(ben);
		}
		
		Pension pension = ben.getPension();
		if (pension == null)
		{
			pension = new Pension();
			pension.setMonetaryBenefit(ben);
			ben.setPension(pension);
		}
		pension.setEffectiveDate(this.build(pension.getEffectiveDate(), metaData.getEffectiveDate()));
		pension.setTerminationDate(this.build(pension.getTerminationDate(), metaData.getTerminationDate()));
		
		if (metaData.getAwardReasonCode() != null)
		{
			pension.setAwardReasonCode((PensionReasonCode)this.pensionReasonCodeBuilder.build(metaData.getAwardReasonCode()));
		}
		
		if (metaData.getTerminationReasonCodes()[0] != null)
		{		
			pension.setTerminationReasonCode1((PensionReasonCode)this.pensionReasonCodeBuilder.build(metaData.getTerminationReasonCodes()[0]));
		}
		if (metaData.getTerminationReasonCodes()[1] != null)
		{		
			pension.setTerminationReasonCode2((PensionReasonCode)this.pensionReasonCodeBuilder.build(metaData.getTerminationReasonCodes()[1]));
		}
		if (metaData.getTerminationReasonCodes()[2] != null)
		{
			pension.setTerminationReasonCode3((PensionReasonCode)this.pensionReasonCodeBuilder.build(metaData.getTerminationReasonCodes()[2]));
		}
		if (metaData.getTerminationReasonCodes()[3] != null)
		{
			pension.setTerminationReasonCode4((PensionReasonCode)this.pensionReasonCodeBuilder.build(metaData.getTerminationReasonCodes()[3]));
		}
	}
	
	
	
}