/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.service.LookupService;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.builder.AbstractBuilder;
import gov.va.med.fw.util.builder.BuilderException;

import org.apache.commons.lang.Validate;

/**
 * @author Martin Francisco
 */
public class VAFacilityBuilder
    extends AbstractBuilder
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 6236921693595290415L;
	private LookupService lookupService;

    /**
     * Default contructor.
     */
    public VAFacilityBuilder()
    {
        super();
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull( this.lookupService, "A lookup service must be configured");
    }

    public LookupService getLookupService() {
        return lookupService;
    }
    
    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }
    
    public VAFacility build(String stationNumber) throws BuilderException
    {
        try
        {
            return getVAFacilityByStationNumber(stationNumber);
        }
        catch(ServiceException e)
        {
            throw new BuilderException(e);
        }
    }

    private VAFacility getVAFacilityByStationNumber(String stationNumber) throws ServiceException {
        return (stationNumber == null) ? null : this.lookupService.getVaFacilityByStationNumber(stationNumber);
    }
}