/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity;

//Java Classes

//Library Classes

//Framework Classes
import gov.va.med.fw.util.builder.BuilderException;
import gov.va.med.fw.hl7.segment.PID;

//Common Classes
import gov.va.med.esr.common.builder.datatype.metadata.CX;
import gov.va.med.esr.common.model.messaging.SiteIdentity;

//Messaging Classes

/**
 * Class to build a site identity object using a message.
 * 
 * @author Carlos Ruiz
 * @version 1.0
 */
public class SiteIdentityBuilder
    extends EntityBuilder
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 7488663849675584029L;

	/**
     * Default contructor.
     */
    public SiteIdentityBuilder()
    {
        super();
    }


    public SiteIdentity build(Object input, Object arg1)
        throws BuilderException
    {
        return this.build((SiteIdentity)input, (PID)arg1);
    }

    public SiteIdentity build(SiteIdentity input, PID pid)
        throws BuilderException
    {
        SiteIdentity output = (input == null) ? new SiteIdentity() : input;

        this.transfer(output, pid);

        return this.shouldKeep(output) ? output : null;
    }


    private boolean shouldKeep(SiteIdentity obj)
    {
        return (obj.getDfn() != null);
    }

    private void transfer(SiteIdentity input, PID pid) throws BuilderException
    {
        CX[] cxs = CX.create(pid.getPatientIdentifierList(), pid
                .getRepeatDelimiter(), pid.getComponentDelimiter(), pid
                .getSubComponentDelimiter());        
        if(pid != null)
        {
            input.setDfn(super
                .build(input.getDfn(), CX.getIdentifierByIdentifierType(cxs, "PI")));
        }
    }

}